/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.config;

import javax.servlet.Filter;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.zowe.apiml.discovery.config.AbstractWebSecurityConfigurer;
import org.zowe.apiml.security.common.config.HandlerInitializer;
import org.zowe.apiml.security.common.content.BasicContentFilter;

@Configuration
@ComponentScan(value={"org.zowe.apiml.security.common", "org.zowe.apiml.gateway.security.login"})
@EnableWebSecurity
@Profile(value={"!https", "!attls"})
public class HttpWebSecurityConfig
extends AbstractWebSecurityConfigurer {
    private static final String DISCOVERY_REALM = "API Mediation Discovery Service realm";
    @Value(value="${apiml.discovery.userid:eureka}")
    private String eurekaUserid;
    @Value(value="${apiml.discovery.password:password}")
    private String eurekaPassword;
    @Value(value="${apiml.metrics.enabled:false}")
    private boolean isMetricsEnabled;
    private final HandlerInitializer handlerInitializer;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.inMemoryAuthentication().withUser(this.eurekaUserid).password("{noop}" + this.eurekaPassword).roles(new String[]{"EUREKA"});
    }

    @Bean
    public WebSecurityCustomizer httpWebSecurityCustomizer() {
        String[] noSecurityAntMatchers = new String[]{"/favicon.ico", "/eureka/css/**", "/eureka/js/**", "/eureka/fonts/**", "/eureka/images/**"};
        return web -> {
            WebSecurity.IgnoredRequestConfigurer cfr_ignored_0 = (WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(noSecurityAntMatchers);
        };
    }

    @Bean
    public SecurityFilterChain httpFilterChain(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)this.baseConfigure(http).httpBasic().realmName(DISCOVERY_REALM).and()).authorizeRequests().antMatchers(new String[]{"/application/info", "/application/health"})).permitAll().antMatchers(new String[]{"/**"})).authenticated();
        if (this.isMetricsEnabled) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/application/hystrix.stream"})).permitAll();
        }
        return (SecurityFilterChain)((HttpSecurity)((CustomSecurityFilters)http.apply((SecurityConfigurerAdapter)new CustomSecurityFilters())).and()).build();
    }

    @Generated
    public HttpWebSecurityConfig(HandlerInitializer handlerInitializer) {
        this.handlerInitializer = handlerInitializer;
    }

    private class CustomSecurityFilters
    extends AbstractHttpConfigurer<CustomSecurityFilters, HttpSecurity> {
        private CustomSecurityFilters() {
        }

        public void configure(HttpSecurity http) {
            AuthenticationManager authenticationManager = (AuthenticationManager)http.getSharedObject(AuthenticationManager.class);
            http.addFilterBefore((Filter)this.basicFilter(authenticationManager), UsernamePasswordAuthenticationFilter.class);
        }

        private BasicContentFilter basicFilter(AuthenticationManager authenticationManager) {
            return new BasicContentFilter(authenticationManager, (AuthenticationFailureHandler)HttpWebSecurityConfig.this.handlerInitializer.getAuthenticationFailureHandler(), HttpWebSecurityConfig.this.handlerInitializer.getResourceAccessExceptionHandler());
        }
    }
}

