/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.cluster.HttpReplicationClient;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.JerseyReplicationClient;
import java.util.Set;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.netflix.eureka.server.ReplicationClientAdditionalFilters;
import org.springframework.context.ApplicationListener;
import org.zowe.apiml.product.eureka.client.ApimlPeerEurekaNode;

public class RefreshablePeerEurekaNodes
extends PeerEurekaNodes
implements ApplicationListener<EnvironmentChangeEvent> {
    private ReplicationClientAdditionalFilters replicationClientAdditionalFilters;

    public RefreshablePeerEurekaNodes(PeerAwareInstanceRegistry registry, EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, ApplicationInfoManager applicationInfoManager, ReplicationClientAdditionalFilters replicationClientAdditionalFilters) {
        super(registry, serverConfig, clientConfig, serverCodecs, applicationInfoManager);
        this.replicationClientAdditionalFilters = replicationClientAdditionalFilters;
    }

    public PeerEurekaNode createPeerEurekaNode(String peerEurekaNodeUrl) {
        JerseyReplicationClient replicationClient = JerseyReplicationClient.createReplicationClient((EurekaServerConfig)this.serverConfig, (ServerCodecs)this.serverCodecs, (String)peerEurekaNodeUrl);
        this.replicationClientAdditionalFilters.getFilters().forEach(arg_0 -> ((JerseyReplicationClient)replicationClient).addReplicationClientFilter(arg_0));
        String targetHost = RefreshablePeerEurekaNodes.hostFromUrl((String)peerEurekaNodeUrl);
        if (targetHost == null) {
            targetHost = "host";
        }
        return new ApimlPeerEurekaNode(this.registry, targetHost, peerEurekaNodeUrl, (HttpReplicationClient)replicationClient, this.serverConfig);
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (this.shouldUpdate(event.getKeys())) {
            this.updatePeerEurekaNodes(this.resolvePeerUrls());
        }
    }

    public boolean shouldUpdate(Set<String> changedKeys) {
        assert (changedKeys != null);
        if (this.clientConfig.shouldUseDnsForFetchingServiceUrls()) {
            return false;
        }
        if (changedKeys.contains("eureka.client.region")) {
            return true;
        }
        for (String key : changedKeys) {
            if (!key.startsWith("eureka.client.service-url.") && !key.startsWith("eureka.client.availability-zones.")) continue;
            return true;
        }
        return false;
    }
}

