/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.health;

import lombok.Generated;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Component;
import org.zowe.apiml.product.constants.CoreService;

@Component
public class DiscoveryServiceHealthIndicator
extends AbstractHealthIndicator {
    private final DiscoveryClient discoveryClient;

    protected void doHealthCheck(Health.Builder builder) {
        String gatewayServiceId = CoreService.GATEWAY.getServiceId();
        boolean gatewayDown = this.discoveryClient.getInstances(gatewayServiceId).isEmpty();
        builder.status(gatewayDown ? new Status("PARTIAL", "Authenticated endpoints not available.") : Status.UP).withDetail(gatewayServiceId, (Object)(gatewayDown ? Status.DOWN : Status.UP));
    }

    @Generated
    public DiscoveryServiceHealthIndicator(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }
}

