/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.staticdef;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.zowe.apiml.auth.Authentication;
import org.zowe.apiml.auth.AuthenticationScheme;
import org.zowe.apiml.config.ApiInfo;
import org.zowe.apiml.discovery.staticdef.CatalogUiTile;
import org.zowe.apiml.discovery.staticdef.Definition;
import org.zowe.apiml.discovery.staticdef.Route;
import org.zowe.apiml.discovery.staticdef.Service;
import org.zowe.apiml.discovery.staticdef.ServiceOverride;
import org.zowe.apiml.discovery.staticdef.ServiceOverrideData;
import org.zowe.apiml.discovery.staticdef.StaticRegistrationResult;
import org.zowe.apiml.eurekaservice.client.util.EurekaMetadataParser;
import org.zowe.apiml.exception.MetadataValidationException;
import org.zowe.apiml.exception.ServiceDefinitionException;
import org.zowe.apiml.message.core.Message;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.product.logging.annotations.InjectApimlLogger;
import org.zowe.apiml.util.MapUtils;
import org.zowe.apiml.util.UrlUtils;

@Component
public class ServiceDefinitionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceDefinitionProcessor.class);
    @InjectApimlLogger
    private ApimlLogger apimlLog = ApimlLogger.empty();
    private static final String STATIC_INSTANCE_ID_PREFIX = "STATIC-";
    private static final DataCenterInfo DEFAULT_INFO = () -> DataCenterInfo.Name.MyOwn;
    private static final String DEFAULT_TILE_VERSION = "1.0.0";
    private static final YAMLFactory YAML_FACTORY = new YAMLFactory();
    private static final String ERROR_PARSING_STATIC_DEFINITION_DATA = "org.zowe.apiml.discovery.errorParsingStaticDefinitionData";

    public ServiceDefinitionProcessor() {
    }

    public ServiceDefinitionProcessor(ApimlLogger apimlLog) {
        this.apimlLog = apimlLog;
    }

    protected List<File> getFiles(StaticRegistrationResult context, String staticApiDefinitionsDirectories) {
        if (StringUtils.isEmpty((String)staticApiDefinitionsDirectories)) {
            log.info("No static definition directory defined");
            return Collections.emptyList();
        }
        String[] directories = staticApiDefinitionsDirectories.split(";");
        return Arrays.stream(directories).filter(s -> !s.isEmpty()).map(File::new).filter(directory -> {
            boolean isDir = directory.isDirectory();
            if (isDir) {
                log.debug("Found directory {}", (Object)directory.getPath());
            } else {
                Message msg = this.apimlLog.log("org.zowe.apiml.discovery.staticDefinitionsDirectoryNotValid", new Object[]{directory.getPath()});
                context.getErrors().add(msg);
            }
            return isDir;
        }).collect(Collectors.toList());
    }

    public StaticRegistrationResult findStaticServicesData(String staticApiDefinitionsDirectories) {
        StaticRegistrationResult context = new StaticRegistrationResult();
        List<File> directories = this.getFiles(context, staticApiDefinitionsDirectories);
        for (File directory : directories) {
            log.info("Scanning directory with static services definition: " + directory);
            File[] files = directory.listFiles((dir, name) -> name.endsWith(".yml"));
            if (files == null) {
                Message msg = this.apimlLog.log("org.zowe.apiml.discovery.errorReadingStaticDefinitionFolder", new Object[]{directory.getAbsolutePath()});
                context.getErrors().add(msg);
                continue;
            }
            if (files.length == 0) {
                log.info("No static service definition found in directory: {}", (Object)directory.getAbsolutePath());
            }
            for (File file : files) {
                Definition definition = this.loadDefinition(context, file);
                if (definition == null) continue;
                this.process(context, file.getAbsolutePath(), definition);
            }
        }
        return context;
    }

    protected Definition loadDefinition(StaticRegistrationResult context, File file) {
        String fileName = file.getAbsolutePath();
        log.info("Static API definition file: {}", (Object)fileName);
        try {
            String content = new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
            return this.loadDefinition(context, fileName, content);
        }
        catch (IOException e) {
            Message msg = this.apimlLog.log("org.zowe.apiml.discovery.errorParsingStaticDefinitionFile", new Object[]{fileName});
            context.getErrors().add(msg);
            return null;
        }
    }

    protected Definition loadDefinition(StaticRegistrationResult context, String ymlFileName, String ymlData) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)YAML_FACTORY);
        try {
            return (Definition)mapper.readValue(ymlData, Definition.class);
        }
        catch (UnrecognizedPropertyException e) {
            Message msg = this.apimlLog.log(ERROR_PARSING_STATIC_DEFINITION_DATA, new Object[]{ymlFileName, e.getOriginalMessage()});
            context.getErrors().add(msg);
            return null;
        }
        catch (IOException e) {
            Message msg = this.apimlLog.log(ERROR_PARSING_STATIC_DEFINITION_DATA, new Object[]{ymlFileName, e.getMessage()});
            context.getErrors().add(msg);
            return null;
        }
    }

    protected void process(StaticRegistrationResult context, String ymlFileName, Definition definition) {
        if (definition == null) {
            return;
        }
        Optional.ofNullable(definition.getServices()).ifPresent(x -> {
            Map tiles = Optional.ofNullable(definition.getCatalogUiTiles()).orElse(Collections.emptyMap());
            x.forEach(y -> this.createInstances(context, ymlFileName, (Service)y, tiles));
        });
        if (definition.getAdditionalServiceMetadata() != null) {
            for (ServiceOverride so : definition.getAdditionalServiceMetadata()) {
                Map<String, String> metadata = null;
                try {
                    metadata = this.createMetadata(so, null, null);
                }
                catch (ServiceDefinitionException e) {
                    Message msg = this.apimlLog.log(ERROR_PARSING_STATIC_DEFINITION_DATA, new Object[]{ymlFileName, e.getMessage()});
                    context.getErrors().add(msg);
                }
                ServiceOverride.Mode mode = Optional.ofNullable(so.getMode()).orElse(ServiceOverride.Mode.UPDATE);
                ServiceOverrideData sod = new ServiceOverrideData(mode, metadata);
                if (context.getAdditionalServiceMetadata().put(so.getServiceId(), sod) == null) continue;
                Message msg = this.apimlLog.log(ERROR_PARSING_STATIC_DEFINITION_DATA, new Object[]{ymlFileName, String.format("Additional service metadata of %s in processing file %s were replaced for duplicities", so.getServiceId(), ymlFileName)});
                context.getErrors().add(msg);
            }
        }
    }

    private CatalogUiTile getTile(StaticRegistrationResult context, String ymlFileName, Map<String, CatalogUiTile> tiles, Service service) {
        if (service.getCatalogUiTileId() != null) {
            CatalogUiTile tile = tiles.get(service.getCatalogUiTileId());
            if (tile == null) {
                Message msg = this.apimlLog.log(ERROR_PARSING_STATIC_DEFINITION_DATA, new Object[]{ymlFileName, String.format("The API Catalog UI tile ID %s is invalid. The service %s will not have API Catalog UI tile", service.getCatalogUiTileId(), service.getServiceId())});
                context.getErrors().add(msg);
            } else {
                tile.setId(service.getCatalogUiTileId());
            }
            return tile;
        }
        return null;
    }

    private List<InstanceInfo> createInstances(StaticRegistrationResult context, String ymlFileName, Service service, Map<String, CatalogUiTile> tiles) {
        try {
            if (service.getServiceId() == null) {
                throw new ServiceDefinitionException(String.format("ServiceId is not defined in the file '%s'. The instance will not be created.", ymlFileName));
            }
            if (service.getInstanceBaseUrls() == null) {
                throw new ServiceDefinitionException(String.format("The instanceBaseUrls parameter of %s is not defined. The instance will not be created.", service.getServiceId()));
            }
            CatalogUiTile tile = this.getTile(context, ymlFileName, tiles, service);
            ArrayList<InstanceInfo> output = new ArrayList<InstanceInfo>(service.getInstanceBaseUrls().size());
            for (String instanceBaseUrl : service.getInstanceBaseUrls()) {
                InstanceInfo instanceInfo = this.buildInstanceInfo(context, service, tile, instanceBaseUrl);
                if (instanceInfo == null) continue;
                output.add(instanceInfo);
            }
            return output;
        }
        catch (ServiceDefinitionException e) {
            Message msg = this.apimlLog.log(ERROR_PARSING_STATIC_DEFINITION_DATA, new Object[]{ymlFileName, e.getMessage()});
            context.getErrors().add(msg);
            return Collections.emptyList();
        }
    }

    private InstanceInfo buildInstanceInfo(StaticRegistrationResult context, Service service, CatalogUiTile tile, String instanceBaseUrl) throws ServiceDefinitionException {
        if (instanceBaseUrl == null || instanceBaseUrl.isEmpty()) {
            throw new ServiceDefinitionException(String.format("One of the instanceBaseUrl of %s is not defined. The instance will not be created.", service.getServiceId()));
        }
        String serviceId = service.getServiceId();
        try {
            URL url = new URL(instanceBaseUrl);
            if (url.getHost().isEmpty()) {
                throw new ServiceDefinitionException(String.format("The URL %s does not contain a hostname. The instance of %s will not be created", instanceBaseUrl, serviceId));
            }
            if (url.getPort() == -1) {
                throw new ServiceDefinitionException(String.format("The URL %s does not contain a port number. The instance of %s will not be created", instanceBaseUrl, serviceId));
            }
            InstanceInfo.Builder builder = InstanceInfo.Builder.newBuilder();
            String instanceId = String.format("%s%s:%s:%s", STATIC_INSTANCE_ID_PREFIX, url.getHost(), serviceId, url.getPort());
            String ipAddress = InetAddress.getByName(url.getHost()).getHostAddress();
            this.setInstanceAttributes(builder, service, instanceId, instanceBaseUrl, url, ipAddress, tile);
            this.setPort(builder, service, instanceBaseUrl, url);
            log.info("Adding static instance {} for service ID {} mapped to URL {}", new Object[]{instanceId, serviceId, url});
            InstanceInfo instance = builder.build();
            context.getInstances().add(instance);
            return instance;
        }
        catch (MalformedURLException e) {
            throw new ServiceDefinitionException(String.format("The URL %s is malformed. The instance of %s will not be created: %s", instanceBaseUrl, serviceId, e.getMessage()));
        }
        catch (UnknownHostException e) {
            throw new ServiceDefinitionException(String.format("The hostname of URL %s is unknown. The instance of %s will not be created: %s", instanceBaseUrl, serviceId, e.getMessage()));
        }
        catch (MetadataValidationException mve) {
            throw new ServiceDefinitionException(String.format("Metadata creation failed. The instance of %s will not be created: %s", new Object[]{serviceId, mve}));
        }
    }

    private void setInstanceAttributes(InstanceInfo.Builder builder, Service service, String instanceId, String instanceBaseUrl, URL url, String ipAddress, CatalogUiTile tile) throws ServiceDefinitionException {
        String serviceId = service.getServiceId();
        builder.setAppName(serviceId).setInstanceId(instanceId).setHostName(url.getHost()).setIPAddr(ipAddress).setDataCenterInfo(DEFAULT_INFO).setVIPAddress(serviceId).setSecureVIPAddress(serviceId).setLeaseInfo(LeaseInfo.Builder.newBuilder().setRenewalIntervalInSecs(30).setDurationInSecs(90).build()).setMetadata(this.createMetadata(service, url, tile));
        if (service.getHomePageRelativeUrl() == null) {
            builder.setHomePageUrl(null, instanceBaseUrl);
        } else {
            builder.setHomePageUrl(null, instanceBaseUrl + service.getHomePageRelativeUrl());
        }
        if (service.getStatusPageRelativeUrl() != null) {
            builder.setStatusPageUrl(null, instanceBaseUrl + service.getStatusPageRelativeUrl());
        }
    }

    private void setPort(InstanceInfo.Builder builder, Service service, String instanceBaseUrl, URL url) throws MalformedURLException {
        switch (url.getProtocol()) {
            case "http": {
                builder.enablePort(InstanceInfo.PortType.SECURE, false).enablePort(InstanceInfo.PortType.UNSECURE, true).setPort(url.getPort()).setSecurePort(0);
                if (service.getHealthCheckRelativeUrl() == null) break;
                builder.setHealthCheckUrls(null, instanceBaseUrl + service.getHealthCheckRelativeUrl(), null);
                break;
            }
            case "https": {
                builder.enablePort(InstanceInfo.PortType.SECURE, true).enablePort(InstanceInfo.PortType.UNSECURE, false).setSecurePort(url.getPort()).setPort(url.getPort());
                if (service.getHealthCheckRelativeUrl() == null) break;
                builder.setHealthCheckUrls(null, null, instanceBaseUrl + service.getHealthCheckRelativeUrl());
                break;
            }
            default: {
                throw new MalformedURLException("Invalid protocol");
            }
        }
    }

    private void setMetadataRoutes(Map<String, String> metadata, List<Route> routes, URL url) {
        if (routes == null) {
            return;
        }
        for (Route rs : routes) {
            String gatewayUrl = UrlUtils.trimSlashes((String)rs.getGatewayUrl());
            String key = gatewayUrl.replace("/", "-");
            metadata.put(String.format("%s.%s.%s", "apiml.routes", key, "gatewayUrl"), gatewayUrl);
            if (url == null) continue;
            String serviceUrl = url.getPath() + (rs.getServiceRelativeUrl() == null ? "" : rs.getServiceRelativeUrl());
            metadata.put(String.format("%s.%s.%s", "apiml.routes", key, "serviceUrl"), serviceUrl);
        }
    }

    private void setMetadataTile(Map<String, String> metadata, CatalogUiTile tile) {
        if (tile == null) {
            return;
        }
        metadata.put("apiml.catalog.tile.id", tile.getId());
        metadata.put("apiml.catalog.tile.version", DEFAULT_TILE_VERSION);
        metadata.put("apiml.catalog.tile.title", tile.getTitle());
        metadata.put("apiml.catalog.tile.description", tile.getDescription());
    }

    private void setMetadataApiInfo(Map<String, String> metadata, List<ApiInfo> appInfoList, String serviceId) {
        if (appInfoList == null) {
            return;
        }
        for (ApiInfo apiInfo : appInfoList) {
            metadata.putAll(EurekaMetadataParser.generateMetadata((String)serviceId, (ApiInfo)apiInfo));
        }
    }

    private void setMetadataAuthentication(Map<String, String> metadata, Authentication authentication) {
        String applid;
        if (authentication == null) {
            return;
        }
        AuthenticationScheme scheme = authentication.getScheme();
        if (scheme != null) {
            metadata.put("apiml.authentication.scheme", scheme.toString());
        }
        if ((applid = authentication.getApplid()) != null) {
            metadata.put("apiml.authentication.applid", applid);
        }
    }

    private void setCustomMetadata(Map<String, String> metadata, Map<String, Object> customMetadata) throws ServiceDefinitionException {
        if (customMetadata != null) {
            try {
                metadata.putAll(MapUtils.flattenMap(null, customMetadata));
            }
            catch (IllegalArgumentException e) {
                throw new ServiceDefinitionException(e.getMessage());
            }
        }
    }

    private Map<String, String> createMetadata(Service service, URL url, CatalogUiTile tile) throws ServiceDefinitionException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("version", "2.2.0");
        metadata.put("apiml.service.title", service.getTitle());
        metadata.put("apiml.service.description", service.getDescription());
        this.setMetadataRoutes(metadata, service.getRoutes(), url);
        this.setMetadataTile(metadata, tile);
        this.setMetadataApiInfo(metadata, service.getApiInfo(), service.getServiceId());
        this.setMetadataAuthentication(metadata, service.getAuthentication());
        this.setCustomMetadata(metadata, service.getCustomMetadata());
        return metadata;
    }
}

