/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.config;

import java.util.Collections;
import javax.servlet.Filter;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;
import org.zowe.apiml.discovery.config.AbstractWebSecurityConfigurer;
import org.zowe.apiml.filter.AttlsFilter;
import org.zowe.apiml.filter.SecureConnectionFilter;
import org.zowe.apiml.security.client.EnableApimlAuth;
import org.zowe.apiml.security.client.login.GatewayLoginProvider;
import org.zowe.apiml.security.client.token.GatewayTokenProvider;
import org.zowe.apiml.security.common.config.AuthConfigurationProperties;
import org.zowe.apiml.security.common.config.HandlerInitializer;
import org.zowe.apiml.security.common.content.BasicContentFilter;
import org.zowe.apiml.security.common.content.BearerContentFilter;
import org.zowe.apiml.security.common.content.CookieContentFilter;

@Configuration
@EnableWebSecurity
@EnableApimlAuth
@Profile(value={"https", "attls"})
public class HttpsWebSecurityConfig
extends AbstractWebSecurityConfigurer {
    private final HandlerInitializer handlerInitializer;
    private final AuthConfigurationProperties securityConfigurationProperties;
    private final GatewayLoginProvider gatewayLoginProvider;
    private final GatewayTokenProvider gatewayTokenProvider;
    private static final String DISCOVERY_REALM = "API Mediation Discovery Service realm";
    @Value(value="${server.attls.enabled:false}")
    private boolean isAttlsEnabled;
    @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifySslCertificatesOfServices;
    @Value(value="${apiml.security.ssl.nonStrictVerifySslCertificatesOfServices:false}")
    private boolean nonStrictVerifySslCertificatesOfServices;
    @Value(value="${apiml.metrics.enabled:false}")
    private boolean isMetricsEnabled;

    @Bean
    public WebSecurityCustomizer httpsWebSecurityCustomizer() {
        String[] noSecurityAntMatchers = new String[]{"/eureka/css/**", "/eureka/js/**", "/eureka/fonts/**", "/eureka/images/**", "/application/health", "/application/info", "/favicon.ico"};
        return web -> {
            web.ignoring().antMatchers(noSecurityAntMatchers);
            if (this.isMetricsEnabled) {
                web.ignoring().antMatchers(new String[]{"/application/hystrixstream"});
            }
        };
    }

    @Bean
    @Order(value=3)
    public SecurityFilterChain basicAuthOrTokenFilterChain(HttpSecurity http) throws Exception {
        this.baseConfigure(http.requestMatchers(matchers -> {
            HttpSecurity.RequestMatcherConfigurer cfr_ignored_0 = (HttpSecurity.RequestMatcherConfigurer)matchers.antMatchers(new String[]{"/application/**", "/*"});
        })).authenticationProvider((AuthenticationProvider)this.gatewayLoginProvider).authenticationProvider((AuthenticationProvider)this.gatewayTokenProvider).authorizeRequests(requests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.antMatchers(new String[]{"/**"})).authenticated()).httpBasic(basic -> basic.realmName(DISCOVERY_REALM));
        if (this.isAttlsEnabled) {
            http.addFilterBefore((Filter)new SecureConnectionFilter(), UsernamePasswordAuthenticationFilter.class);
        }
        return (SecurityFilterChain)((HttpSecurity)((CustomSecurityFilters)http.apply((SecurityConfigurerAdapter)new CustomSecurityFilters())).and()).build();
    }

    @Bean
    @Order(value=2)
    public SecurityFilterChain clientCertificateFilterChain(HttpSecurity http) throws Exception {
        this.baseConfigure(http.antMatcher("/eureka/**"));
        if (this.verifySslCertificatesOfServices || !this.nonStrictVerifySslCertificatesOfServices) {
            http.authorizeRequests(requests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated()).x509(x509 -> x509.userDetailsService(this.x509UserDetailsService()));
            if (this.isAttlsEnabled) {
                http.addFilterBefore((Filter)new AttlsFilter(), X509AuthenticationFilter.class);
                http.addFilterBefore((Filter)new SecureConnectionFilter(), AttlsFilter.class);
            }
        } else {
            http.authorizeRequests(requests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).permitAll());
        }
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @Order(value=1)
    public SecurityFilterChain basicAuthOrTokenOrCertFilterChain(HttpSecurity http) throws Exception {
        this.baseConfigure(http.antMatcher("/discovery/**")).authenticationProvider((AuthenticationProvider)this.gatewayLoginProvider).authenticationProvider((AuthenticationProvider)this.gatewayTokenProvider).httpBasic(basic -> basic.realmName(DISCOVERY_REALM));
        if (this.verifySslCertificatesOfServices || !this.nonStrictVerifySslCertificatesOfServices) {
            http.authorizeRequests(requests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated()).x509(x509 -> x509.userDetailsService(this.x509UserDetailsService()));
            if (this.isAttlsEnabled) {
                http.addFilterBefore((Filter)new AttlsFilter(), X509AuthenticationFilter.class);
                http.addFilterBefore((Filter)new SecureConnectionFilter(), AttlsFilter.class);
            }
        }
        return (SecurityFilterChain)((HttpSecurity)((CustomSecurityFilters)http.apply((SecurityConfigurerAdapter)new CustomSecurityFilters())).and()).build();
    }

    private UserDetailsService x509UserDetailsService() {
        return username -> new User("eurekaClient", "", Collections.emptyList());
    }

    @Generated
    public HttpsWebSecurityConfig(HandlerInitializer handlerInitializer, AuthConfigurationProperties securityConfigurationProperties, GatewayLoginProvider gatewayLoginProvider, GatewayTokenProvider gatewayTokenProvider) {
        this.handlerInitializer = handlerInitializer;
        this.securityConfigurationProperties = securityConfigurationProperties;
        this.gatewayLoginProvider = gatewayLoginProvider;
        this.gatewayTokenProvider = gatewayTokenProvider;
    }

    private class CustomSecurityFilters
    extends AbstractHttpConfigurer<CustomSecurityFilters, HttpSecurity> {
        private CustomSecurityFilters() {
        }

        public void configure(HttpSecurity http) {
            AuthenticationManager authenticationManager = (AuthenticationManager)http.getSharedObject(AuthenticationManager.class);
            http.addFilterBefore((Filter)this.basicFilter(authenticationManager), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.cookieFilter(authenticationManager), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.bearerContentFilter(authenticationManager), UsernamePasswordAuthenticationFilter.class);
        }

        private BasicContentFilter basicFilter(AuthenticationManager authenticationManager) {
            return new BasicContentFilter(authenticationManager, (AuthenticationFailureHandler)HttpsWebSecurityConfig.this.handlerInitializer.getAuthenticationFailureHandler(), HttpsWebSecurityConfig.this.handlerInitializer.getResourceAccessExceptionHandler());
        }

        private CookieContentFilter cookieFilter(AuthenticationManager authenticationManager) {
            return new CookieContentFilter(authenticationManager, (AuthenticationFailureHandler)HttpsWebSecurityConfig.this.handlerInitializer.getAuthenticationFailureHandler(), HttpsWebSecurityConfig.this.handlerInitializer.getResourceAccessExceptionHandler(), HttpsWebSecurityConfig.this.securityConfigurationProperties);
        }

        private BearerContentFilter bearerContentFilter(AuthenticationManager authenticationManager) {
            return new BearerContentFilter(authenticationManager, (AuthenticationFailureHandler)HttpsWebSecurityConfig.this.handlerInitializer.getAuthenticationFailureHandler(), HttpsWebSecurityConfig.this.handlerInitializer.getResourceAccessExceptionHandler());
        }
    }
}

