/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.config;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ServerCodecs;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.eureka.server.InstanceRegistryProperties;
import org.springframework.cloud.netflix.eureka.server.ReplicationClientAdditionalFilters;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.zowe.apiml.discovery.ApimlInstanceRegistry;
import org.zowe.apiml.discovery.eureka.RefreshablePeerEurekaNodes;

@Configuration
public class EurekaConfig {
    @Value(value="${apiml.discovery.serviceIdPrefixReplacer:#{null}}")
    private String tuple;
    @Value(value="${apiml.discovery.maxPeerRetries:10}")
    private int maxPeerRetries;

    @Bean
    @Primary
    public ApimlInstanceRegistry getApimlInstanceRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, EurekaClient eurekaClient, InstanceRegistryProperties instanceRegistryProperties, ApplicationContext appCntx) {
        eurekaClient.getApplications();
        return new ApimlInstanceRegistry(serverConfig, clientConfig, serverCodecs, eurekaClient, instanceRegistryProperties, appCntx, new Tuple(this.tuple));
    }

    @Bean
    @Primary
    public PeerEurekaNodes peerEurekaNodes(PeerAwareInstanceRegistry registry, ServerCodecs serverCodecs, ReplicationClientAdditionalFilters replicationClientAdditionalFilters, ApplicationInfoManager applicationInfoManager, EurekaServerConfig eurekaServerConfig, EurekaClientConfig eurekaClientConfig) {
        return new RefreshablePeerEurekaNodes(registry, eurekaServerConfig, eurekaClientConfig, serverCodecs, applicationInfoManager, replicationClientAdditionalFilters, this.maxPeerRetries);
    }

    public static class Tuple {
        boolean valid;
        String oldPrefix;
        String newPrefix;

        public Tuple(String tuple) {
            if (Tuple.isValidTuple(tuple)) {
                String[] prefixes = tuple.split(",");
                this.oldPrefix = prefixes[0];
                this.newPrefix = prefixes[1];
                this.valid = true;
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getOldPrefix() {
            return this.oldPrefix;
        }

        public String getNewPrefix() {
            return this.newPrefix;
        }

        public static boolean isValidTuple(String tuple) {
            if (StringUtils.isNotEmpty((CharSequence)tuple)) {
                String[] replacer = tuple.split(",");
                return replacer.length > 1 && StringUtils.isNotEmpty((CharSequence)replacer[0]) && StringUtils.isNotEmpty((CharSequence)replacer[1]) && !replacer[0].equals(replacer[1]);
            }
            return false;
        }
    }
}

