/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery;

import javax.annotation.Nonnull;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.netflix.eureka.server.EnableEurekaServer;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.zowe.apiml.product.logging.annotations.EnableApimlLogger;
import org.zowe.apiml.product.monitoring.LatencyUtilsConfigInitializer;
import org.zowe.apiml.product.service.ServiceStartupEventHandler;
import org.zowe.apiml.product.version.BuildInfo;

@EnableEurekaServer
@SpringBootApplication
@EnableCircuitBreaker
@ComponentScan(value={"org.zowe.apiml.discovery", "org.zowe.apiml.product.security", "org.zowe.apiml.product.web"})
@EnableApimlLogger
public class DiscoveryServiceApplication
implements ApplicationListener<ApplicationReadyEvent> {
    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{DiscoveryServiceApplication.class});
        app.addInitializers(new ApplicationContextInitializer[]{new LatencyUtilsConfigInitializer()});
        app.setLogStartupInfo(false);
        new BuildInfo().logBuildInfo();
        app.run(args);
    }

    public void onApplicationEvent(@Nonnull ApplicationReadyEvent event) {
        new ServiceStartupEventHandler().onServiceStartup("Discovery Service", 5);
    }
}

