/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.config;

import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.client.AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.DefaultServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.server.ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.security.web.server.savedrequest.CookieServerRequestCache;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.server.ServerWebExchange;
import org.zowe.apiml.cloudgatewayservice.config.oidc.ClientConfiguration;
import org.zowe.apiml.product.constants.CoreService;
import reactor.core.publisher.Mono;

@Configuration
public class WebSecurity {
    public static final String CONTEXT_PATH = "/" + CoreService.CLOUD_GATEWAY.getServiceId();
    public static final String REGISTRY_PATH = CONTEXT_PATH + "/api/v1/registry/**";
    public static final String COOKIE_NONCE = "oidc_nonce";
    public static final String COOKIE_STATE = "oidc_state";
    public static final String COOKIE_RETURN_URL = "oidc_return_url";
    private static final Pattern CLIENT_REG_ID = Pattern.compile("^" + CONTEXT_PATH + "/login/oauth2/code/([^/]+)$");
    private static final Predicate<HttpCookie> HAS_NO_VALUE = cookie -> cookie == null || StringUtils.isEmpty((CharSequence)cookie.getValue());
    private static final List<String> COOKIES = Arrays.asList("oidc_nonce", "oidc_state", "oidc_return_url");
    public static final String OAUTH_2_AUTHORIZATION = CONTEXT_PATH + "/oauth2/authorization/**";
    public static final String OAUTH_2_AUTHORIZATION_BASE_URI = CONTEXT_PATH + "/oauth2/authorization/";
    public static final String OAUTH_2_AUTHORIZATION_URI = CONTEXT_PATH + "/oauth2/authorization/{registrationId}";
    public static final String OAUTH_2_REDIRECT_URI = CONTEXT_PATH + "/login/oauth2/code/**";
    public static final String OAUTH_2_REDIRECT_LOGIN_URI = CONTEXT_PATH + "/login/oauth2/code/{registrationId}";
    @Value(value="${apiml.security.oidc.cookie.sameSite:Lax}")
    public String sameSite;
    @Value(value="${apiml.security.x509.registry.allowedUsers:#{null}}")
    private String allowedUsers;
    private final ClientConfiguration clientConfiguration;
    private Predicate<String> usernameAuthorizationTester;

    @PostConstruct
    void initScopes() {
        boolean authorizeAnyUsers = "*".equals(this.allowedUsers);
        Set users = Optional.ofNullable(this.allowedUsers).map(line -> line.split("[,;]")).map(Arrays::asList).orElse(Collections.emptyList()).stream().map(String::trim).map(String::toLowerCase).collect(Collectors.toSet());
        this.usernameAuthorizationTester = user -> authorizeAnyUsers || users.contains(StringUtils.lowerCase((String)user));
    }

    private ResponseCookie.ResponseCookieBuilder defaultCookieAttr(ResponseCookie.ResponseCookieBuilder builder) {
        return builder.path("/").sameSite(this.sameSite).httpOnly(true).secure(true);
    }

    private ResponseCookie createCookie(String name, String value) {
        return this.defaultCookieAttr(ResponseCookie.from((String)name, (String)value)).build();
    }

    @Bean
    @Order(value=-2147483648)
    public SecurityWebFilterChain oauth2WebFilterChain(ServerHttpSecurity http, Optional<ReactiveOAuth2AuthorizedClientService> reactiveOAuth2AuthorizedClientService, Optional<ApimlServerAuthorizationRequestRepository> requestRepository, Optional<ServerOAuth2AuthorizationRequestResolver> authorizationRequestResolver) {
        if (!this.clientConfiguration.isConfigured()) {
            return null;
        }
        return http.headers(customizer -> customizer.frameOptions(ServerHttpSecurity.HeaderSpec.FrameOptionsSpec::disable)).securityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance()).securityMatcher(ServerWebExchangeMatchers.pathMatchers((String[])new String[]{OAUTH_2_AUTHORIZATION, OAUTH_2_REDIRECT_URI})).authorizeExchange(authorize -> authorize.anyExchange().authenticated()).oauth2Login(oauth2 -> oauth2.authenticationMatcher((ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher(OAUTH_2_REDIRECT_LOGIN_URI)).authorizationRequestRepository((ServerAuthorizationRequestRepository)requestRepository.orElseThrow(() -> new NoSuchBeanDefinitionException(ApimlServerAuthorizationRequestRepository.class))).authorizationRequestResolver((ServerOAuth2AuthorizationRequestResolver)authorizationRequestResolver.orElseThrow(() -> new NoSuchBeanDefinitionException(ServerOAuth2AuthorizationRequestResolver.class))).authenticationSuccessHandler((webFilterExchange, authentication) -> ((ReactiveOAuth2AuthorizedClientService)reactiveOAuth2AuthorizedClientService.orElseThrow(() -> new NoSuchBeanDefinitionException(ReactiveOAuth2AuthorizedClientService.class))).loadAuthorizedClient(WebSecurity.getClientRegistrationId(webFilterExchange.getExchange()), authentication.getName()).map(oAuth2AuthorizedClient -> this.updateCookies(webFilterExchange, (OAuth2AuthorizedClient)oAuth2AuthorizedClient)).flatMap(x -> Mono.empty())).authenticationFailureHandler((webFilterExchange, exception) -> {
            String clientRegistrationId = WebSecurity.getClientRegistrationId(webFilterExchange.getExchange());
            this.clearCookies(webFilterExchange);
            this.redirect(webFilterExchange.getExchange().getResponse(), OAUTH_2_AUTHORIZATION_BASE_URI + clientRegistrationId);
            return Mono.empty();
        })).oauth2Client(oAuth2ClientSpec -> oAuth2ClientSpec.authorizationRequestRepository((ServerAuthorizationRequestRepository)requestRepository.orElseThrow(() -> new NoSuchBeanDefinitionException(ApimlServerAuthorizationRequestRepository.class)))).requestCache(requestCacheSpec -> requestCacheSpec.requestCache((ServerRequestCache)new CookieServerRequestCache())).build();
    }

    public Mono<Object> updateCookies(WebFilterExchange webFilterExchange, OAuth2AuthorizedClient oAuth2AuthorizedClient) {
        webFilterExchange.getExchange().getResponse().addCookie(this.defaultCookieAttr(ResponseCookie.from((String)"apimlAuthenticationToken", (String)oAuth2AuthorizedClient.getAccessToken().getTokenValue())).build());
        HttpCookie location = (HttpCookie)webFilterExchange.getExchange().getRequest().getCookies().getFirst((Object)COOKIE_RETURN_URL);
        if (!HAS_NO_VALUE.test(location)) {
            this.redirect(webFilterExchange.getExchange().getResponse(), location.getValue());
        }
        this.clearCookies(webFilterExchange);
        return Mono.empty();
    }

    private void redirect(ServerHttpResponse response, String location) {
        response.getHeaders().set("Location", location);
        response.setStatusCode(HttpStatusCode.valueOf((int)302));
    }

    private void clearCookies(WebFilterExchange webFilterExchange) {
        COOKIES.forEach(cookie -> webFilterExchange.getExchange().getResponse().addCookie(this.defaultCookieAttr(ResponseCookie.from((String)cookie).maxAge(0L)).build()));
    }

    @Bean
    ReactiveOAuth2AuthorizedClientService authorizedClientService(Optional<ReactiveClientRegistrationRepository> clientRegistrationRepository) {
        if (!this.clientConfiguration.isConfigured()) {
            return null;
        }
        return new InMemoryReactiveOAuth2AuthorizedClientService(clientRegistrationRepository.orElseThrow(() -> new NoSuchBeanDefinitionException(ReactiveClientRegistrationRepository.class)));
    }

    @Bean
    public ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver(Optional<InMemoryReactiveClientRegistrationRepository> inMemoryReactiveClientRegistrationRepository) {
        if (!this.clientConfiguration.isConfigured()) {
            return null;
        }
        return new DefaultServerOAuth2AuthorizationRequestResolver((ReactiveClientRegistrationRepository)inMemoryReactiveClientRegistrationRepository.orElseThrow(() -> new NoSuchBeanDefinitionException(InMemoryReactiveClientRegistrationRepository.class)), (ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher(OAUTH_2_AUTHORIZATION_URI));
    }

    @Bean
    public ApimlServerAuthorizationRequestRepository requestRepository(Optional<ServerOAuth2AuthorizationRequestResolver> authorizationRequestResolver) {
        if (!this.clientConfiguration.isConfigured()) {
            return null;
        }
        return new ApimlServerAuthorizationRequestRepository(authorizationRequestResolver.orElseThrow(() -> new NoSuchBeanDefinitionException(ServerOAuth2AuthorizationRequestResolver.class)));
    }

    @Bean
    public ReactiveClientRegistrationRepository clientRegistrationRepository() {
        if (!this.clientConfiguration.isConfigured()) {
            return null;
        }
        return new InMemoryReactiveClientRegistrationRepository(this.getClientRegistrations());
    }

    @Bean
    public ServerOAuth2AuthorizedClientRepository serverOAuth2AuthorizedClientRepository(Optional<ReactiveOAuth2AuthorizedClientService> clientService) {
        if (!this.clientConfiguration.isConfigured()) {
            return null;
        }
        return new AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository(clientService.orElseThrow(() -> new NoSuchBeanDefinitionException(ReactiveOAuth2AuthorizedClientService.class)));
    }

    @Bean
    @ConditionalOnBean(value={ReactiveClientRegistrationRepository.class})
    public ReactiveOAuth2AuthorizedClientManager gatewayReactiveOAuth2AuthorizedClientManager(Optional<ReactiveClientRegistrationRepository> clientRegistrationRepository, Optional<ReactiveOAuth2AuthorizedClientService> authorizedClientService) {
        if (!this.clientConfiguration.isConfigured()) {
            return null;
        }
        ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = ReactiveOAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().build();
        AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager(clientRegistrationRepository.orElseThrow(() -> new NoSuchBeanDefinitionException(ReactiveClientRegistrationRepository.class)), authorizedClientService.orElseThrow(() -> new NoSuchBeanDefinitionException(ReactiveOAuth2AuthorizedClientService.class)));
        authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
        return authorizedClientManager;
    }

    private List<ClientRegistration> getClientRegistrations() {
        return this.clientConfiguration.getConfigurations().values().stream().map(c -> ClientRegistration.withRegistrationId((String)c.getId()).clientId(c.getRegistration().getClientId()).clientSecret(c.getRegistration().getClientSecret()).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri(c.getRegistration().getRedirectUri()).scope(c.getRegistration().getScope()).authorizationUri(c.getProvider().getAuthorizationUri()).tokenUri(c.getProvider().getTokenUri()).userInfoUri(c.getProvider().getUserInfoUri()).userNameAttributeName(c.getProvider().getUserNameAttribute()).jwkSetUri(c.getProvider().getJwkSetUri()).clientName(c.getId()).build()).collect(Collectors.toList());
    }

    @Bean
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        return http.headers(customizer -> customizer.frameOptions(ServerHttpSecurity.HeaderSpec.FrameOptionsSpec::disable)).x509(x509 -> x509.principalExtractor((X509PrincipalExtractor)new SubjectDnX509PrincipalExtractor()).authenticationManager(authentication -> {
            authentication.setAuthenticated(true);
            return Mono.just((Object)authentication);
        })).authorizeExchange(authorizeExchangeSpec -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchangeSpec.pathMatchers(new String[]{REGISTRY_PATH})).authenticated().anyExchange().permitAll()).csrf(ServerHttpSecurity.CsrfSpec::disable).build();
    }

    @Bean
    @Primary
    ReactiveUserDetailsService userDetailsService() {
        return username -> {
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            if (this.usernameAuthorizationTester.test(username)) {
                authorities.add(new SimpleGrantedAuthority("REGISTRY"));
            }
            UserDetails userDetails = User.withUsername((String)username).authorities(authorities).password("").build();
            return Mono.just((Object)userDetails);
        };
    }

    static String getClientRegistrationId(ServerWebExchange exchange) {
        String path = exchange.getRequest().getPath().value();
        Matcher matcher = CLIENT_REG_ID.matcher(path);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalStateException("Client registration ID was not found in the path: " + path);
    }

    @Generated
    public WebSecurity(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    class ApimlServerAuthorizationRequestRepository
    implements ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> {
        final ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver;

        public Mono<OAuth2AuthorizationRequest> loadAuthorizationRequest(ServerWebExchange exchange) {
            String registrationId = WebSecurity.getClientRegistrationId(exchange);
            return this.authorizationRequestResolver.resolve(exchange, registrationId).map(arr -> {
                HttpCookie nonceCookie = (HttpCookie)exchange.getRequest().getCookies().getFirst((Object)WebSecurity.COOKIE_NONCE);
                if (nonceCookie != null) {
                    return this.createAuthorizationRequest(exchange, (OAuth2AuthorizationRequest)arr);
                }
                return arr;
            });
        }

        public OAuth2AuthorizationRequest createAuthorizationRequest(ServerWebExchange exchange, OAuth2AuthorizationRequest original) {
            HttpCookie nonceCookie = (HttpCookie)exchange.getRequest().getCookies().getFirst((Object)WebSecurity.COOKIE_NONCE);
            HttpCookie stateCookie = (HttpCookie)exchange.getRequest().getCookies().getFirst((Object)WebSecurity.COOKIE_STATE);
            if (HAS_NO_VALUE.test(nonceCookie) || HAS_NO_VALUE.test(stateCookie)) {
                return original;
            }
            String nonce = nonceCookie.getValue();
            String nonceHash = ApimlServerAuthorizationRequestRepository.createHash(nonce);
            return OAuth2AuthorizationRequest.authorizationCode().attributes(attrs -> {
                attrs.put("registration_id", original.getAttributes().get("registration_id"));
                attrs.put("nonce", nonce);
            }).additionalParameters(params -> params.put("nonce", nonceHash)).clientId(original.getClientId()).authorizationUri(original.getAuthorizationUri()).redirectUri(original.getRedirectUri()).scopes(original.getScopes()).state(stateCookie.getValue()).build();
        }

        private static String createHash(String value) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] digest = md.digest(value.getBytes(StandardCharsets.US_ASCII));
                return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }

        public Mono<Void> saveAuthorizationRequest(OAuth2AuthorizationRequest authorizationRequest, ServerWebExchange exchange) {
            exchange.getResponse().addCookie(WebSecurity.this.createCookie(WebSecurity.COOKIE_NONCE, String.valueOf(authorizationRequest.getAttributes().get("nonce"))));
            exchange.getResponse().addCookie(WebSecurity.this.createCookie(WebSecurity.COOKIE_RETURN_URL, this.getReturnUrl(exchange)));
            exchange.getResponse().addCookie(WebSecurity.this.createCookie(WebSecurity.COOKIE_STATE, authorizationRequest.getState()));
            return Mono.empty();
        }

        String getReturnUrl(ServerWebExchange exchange) {
            return Optional.ofNullable((String)exchange.getRequest().getQueryParams().getFirst((Object)"returnUrl")).orElse(exchange.getRequest().getHeaders().getFirst("Origin"));
        }

        public Mono<OAuth2AuthorizationRequest> removeAuthorizationRequest(ServerWebExchange exchange) {
            Mono<OAuth2AuthorizationRequest> requestMono = this.loadAuthorizationRequest(exchange);
            exchange.getResponse().getCookies().remove((Object)WebSecurity.COOKIE_NONCE);
            return requestMono;
        }

        @Generated
        public ApimlServerAuthorizationRequestRepository(ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver) {
            this.authorizationRequestResolver = authorizationRequestResolver;
        }
    }
}

