/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import jakarta.validation.constraints.NotEmpty;
import java.util.function.Predicate;
import lombok.Generated;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

@Service
public class MissingHeaderRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public MissingHeaderRoutePredicateFactory() {
        super(Config.class);
    }

    public Predicate<ServerWebExchange> apply(final Config config) {
        return new GatewayPredicate(){

            public boolean test(ServerWebExchange exchange) {
                return !exchange.getRequest().getHeaders().containsKey((Object)config.header);
            }

            public Object getConfig() {
                return config;
            }

            public String toString() {
                return String.format("Missing header: %s", config.header);
            }
        };
    }

    @Validated
    public static class Config {
        @NotEmpty
        private String header;

        public Config setHeader(String header) {
            this.header = header;
            return this;
        }

        @Generated
        public String getHeader() {
            return this.header;
        }
    }
}

