/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.config.oidc;

import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.zowe.apiml.cloudgatewayservice.config.oidc.Provider;
import org.zowe.apiml.cloudgatewayservice.config.oidc.Registration;

@Component
@ConfigurationProperties(prefix="spring.security.oauth2.client", ignoreInvalidFields=true)
public class ClientConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientConfiguration.class);
    private static final String SYSTEM_ENV_PREFIX = "ZWE_configs_spring_security_oauth2_client_";
    private static final Pattern REGISTRATION_ID_PATTERN = Pattern.compile("^ZWE_configs_spring_security_oauth2_client_([^_]+)_.*$");
    private Map<String, Registration> registration = new HashMap<String, Registration>();
    private Map<String, Provider> provider = new HashMap<String, Provider>();

    private String getSystemEnv(String id, String name) {
        return System.getProperty(SYSTEM_ENV_PREFIX + id + "_" + name);
    }

    private void update(String id, String base, Consumer<String> setter) {
        String systemEnv = this.getSystemEnv(id, base);
        if (systemEnv != null) {
            setter.accept(systemEnv);
        }
    }

    private void update(String id, Registration registration) {
        this.update(id, "registration_clientId", registration::setClientId);
        this.update(id, "registration_clientSecret", registration::setClientSecret);
        this.update(id, "registration_redirectUri", registration::setRedirectUri);
        String scope = this.getSystemEnv(id, "registration_scope");
        if (scope != null) {
            registration.setScope(Arrays.asList(scope.split("[,]")));
        }
    }

    private void update(String id, Provider provider) {
        this.update(id, "provider_authorizationUri", provider::setAuthorizationUri);
        this.update(id, "provider_tokenUri", provider::setTokenUri);
        this.update(id, "provider_userInfoUri", provider::setUserInfoUri);
        this.update(id, "provider_userNameAttribute", provider::setUserNameAttribute);
        this.update(id, "provider_jwkSetUri", provider::setJwkSetUri);
    }

    private Set<String> getRegistrationsIdsFromSystemEnv() {
        return System.getProperties().keySet().stream().map(key -> {
            Matcher matcher = REGISTRATION_ID_PATTERN.matcher(String.valueOf(key));
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @PostConstruct
    void updateWithSystemEnvironment() {
        for (String registrationId : this.getRegistrationsIdsFromSystemEnv()) {
            this.update(registrationId, this.registration.computeIfAbsent(registrationId, k -> new Registration()));
            this.update(registrationId, this.provider.computeIfAbsent(registrationId, k -> new Provider()));
        }
    }

    public Map<String, Config> getConfigurations() {
        HashMap<String, Config> map = new HashMap<String, Config>();
        for (Map.Entry<String, Registration> registrationEntry : this.registration.entrySet()) {
            String id = registrationEntry.getKey();
            Provider providerConfig = this.provider.get(id);
            if (providerConfig == null) continue;
            map.put(id, Config.builder().id(id).registration(registrationEntry.getValue()).provider(providerConfig).build());
        }
        if (map.size() < Math.max(this.registration.size(), this.provider.size())) {
            log.debug("OIDC configuration is not complete, please refer to the documentation.");
        }
        return map;
    }

    public boolean isConfigured() {
        if (!Optional.ofNullable(this.registration).map(m -> !m.isEmpty()).orElse(false).booleanValue()) {
            return false;
        }
        return Optional.ofNullable(this.provider).map(m -> !m.isEmpty()).orElse(false);
    }

    @Generated
    public ClientConfiguration() {
    }

    @Generated
    public Map<String, Registration> getRegistration() {
        return this.registration;
    }

    @Generated
    public Map<String, Provider> getProvider() {
        return this.provider;
    }

    @Generated
    public void setRegistration(Map<String, Registration> registration) {
        this.registration = registration;
    }

    @Generated
    public void setProvider(Map<String, Provider> provider) {
        this.provider = provider;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfiguration)) {
            return false;
        }
        ClientConfiguration other = (ClientConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Registration> this$registration = this.getRegistration();
        Map<String, Registration> other$registration = other.getRegistration();
        if (this$registration == null ? other$registration != null : !((Object)this$registration).equals(other$registration)) {
            return false;
        }
        Map<String, Provider> this$provider = this.getProvider();
        Map<String, Provider> other$provider = other.getProvider();
        return !(this$provider == null ? other$provider != null : !((Object)this$provider).equals(other$provider));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Registration> $registration = this.getRegistration();
        result = result * 59 + ($registration == null ? 43 : ((Object)$registration).hashCode());
        Map<String, Provider> $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : ((Object)$provider).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientConfiguration(registration=" + this.getRegistration() + ", provider=" + this.getProvider() + ")";
    }

    public static final class Config {
        private final String id;
        private final Registration registration;
        private final Provider provider;

        @Generated
        Config(String id, Registration registration, Provider provider) {
            this.id = id;
            this.registration = registration;
            this.provider = provider;
        }

        @Generated
        static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Registration getRegistration() {
            return this.registration;
        }

        @Generated
        public Provider getProvider() {
            return this.provider;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Registration this$registration = this.getRegistration();
            Registration other$registration = other.getRegistration();
            if (this$registration == null ? other$registration != null : !((Object)this$registration).equals(other$registration)) {
                return false;
            }
            Provider this$provider = this.getProvider();
            Provider other$provider = other.getProvider();
            return !(this$provider == null ? other$provider != null : !((Object)this$provider).equals(other$provider));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Registration $registration = this.getRegistration();
            result = result * 59 + ($registration == null ? 43 : ((Object)$registration).hashCode());
            Provider $provider = this.getProvider();
            result = result * 59 + ($provider == null ? 43 : ((Object)$provider).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientConfiguration.Config(id=" + this.getId() + ", registration=" + this.getRegistration() + ", provider=" + this.getProvider() + ")";
        }

        @Generated
        static class ConfigBuilder {
            @Generated
            private String id;
            @Generated
            private Registration registration;
            @Generated
            private Provider provider;

            @Generated
            ConfigBuilder() {
            }

            @Generated
            ConfigBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            ConfigBuilder registration(Registration registration) {
                this.registration = registration;
                return this;
            }

            @Generated
            ConfigBuilder provider(Provider provider) {
                this.provider = provider;
                return this;
            }

            @Generated
            Config build() {
                return new Config(this.id, this.registration, this.provider);
            }

            @Generated
            public String toString() {
                return "ClientConfiguration.Config.ConfigBuilder(id=" + this.id + ", registration=" + this.registration + ", provider=" + this.provider + ")";
            }
        }
    }
}

