/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.service;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;
import org.zowe.apiml.security.HttpsConfigError;

public class WebClientHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebClientHelper.class);
    private static final ApimlLogger apimlLog = ApimlLogger.of(WebClientHelper.class, (MessageService)YamlMessageServiceInstance.getInstance());

    public static SslContext load(String keystorePath, char[] password, String keystoreType) {
        File keyStoreFile = new File(keystorePath);
        if (keyStoreFile.exists()) {
            SslContext sslContext;
            block9: {
                InputStream is = Files.newInputStream(Paths.get(keystorePath, new String[0]), new OpenOption[0]);
                try {
                    KeyStore keyStore = KeyStore.getInstance(keystoreType);
                    keyStore.load(is, password);
                    sslContext = WebClientHelper.initSslContext(keyStore, password);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        apimlLog.log("org.zowe.apiml.common.sslContextInitializationError", new Object[]{e.getMessage()});
                        throw new HttpsConfigError("Error initializing SSL Context: " + e.getMessage(), (Throwable)e, HttpsConfigError.ErrorCode.HTTP_CLIENT_INITIALIZATION_FAILED);
                    }
                }
                is.close();
            }
            return sslContext;
        }
        throw new IllegalArgumentException("Not existing file: " + keystorePath);
    }

    private static SslContext initSslContext(KeyStore keyStore, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, SSLException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX");
        kmf.init(keyStore, password);
        return SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).keyManager(kmf).build();
    }

    @Generated
    protected WebClientHelper() {
    }
}

