/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.config;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.zowe.apiml.product.constants.CoreService;
import reactor.core.publisher.Mono;

@Configuration
public class WebSecurity {
    @Value(value="${apiml.security.x509.registry.allowedUsers:#{null}}")
    private String allowedUsers;
    private Predicate<String> usernameAuthorizationTester;

    @PostConstruct
    void initScopes() {
        boolean authorizeAnyUsers = "*".equals(this.allowedUsers);
        Set users = Optional.ofNullable(this.allowedUsers).map(line -> line.split("[,;]")).map(Arrays::asList).orElse(Collections.emptyList()).stream().map(String::trim).map(String::toLowerCase).collect(Collectors.toSet());
        this.usernameAuthorizationTester = user -> authorizeAnyUsers || users.contains(StringUtils.lowerCase((String)user));
    }

    @Bean
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        SubjectDnX509PrincipalExtractor principalExtractor = new SubjectDnX509PrincipalExtractor();
        ReactiveAuthenticationManager authenticationManager = authentication -> {
            authentication.setAuthenticated(true);
            return Mono.just((Object)authentication);
        };
        http.x509(x509 -> x509.principalExtractor((X509PrincipalExtractor)principalExtractor).authenticationManager(authenticationManager)).authorizeExchange(authorizeExchangeSpec -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchangeSpec.pathMatchers(new String[]{"/" + CoreService.CLOUD_GATEWAY.getServiceId() + "/api/v1/registry/**"})).authenticated()).authorizeExchange(authorizeExchangeSpec -> authorizeExchangeSpec.anyExchange().permitAll()).csrf(ServerHttpSecurity.CsrfSpec::disable);
        return http.build();
    }

    @Bean
    @Primary
    ReactiveUserDetailsService userDetailsService() {
        return username -> {
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            if (this.usernameAuthorizationTester.test(username)) {
                authorities.add(new SimpleGrantedAuthority("REGISTRY"));
            }
            UserDetails userDetails = User.withUsername((String)username).authorities(authorities).password("").build();
            return Mono.just((Object)userDetails);
        };
    }
}

