/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.zowe.apiml.cloudgatewayservice.service.ProxyRouteLocator;
import org.zowe.apiml.cloudgatewayservice.service.RouteLocator;
import org.zowe.apiml.util.CorsUtils;

@Configuration
public class RoutingConfig {
    @Value(value="${apiml.service.ignoredHeadersWhenCorsEnabled:-}")
    private String ignoredHeadersWhenCorsEnabled;

    @Bean
    @ConditionalOnProperty(name={"apiml.service.gateway.proxy.enabled"}, havingValue="false")
    public RouteLocator apimlDiscoveryRouteDefLocator(ReactiveDiscoveryClient discoveryClient, DiscoveryLocatorProperties properties, List<FilterDefinition> filters, ApplicationContext context, CorsUtils corsUtils) {
        return new RouteLocator(discoveryClient, properties, filters, context, corsUtils);
    }

    @Bean
    @ConditionalOnProperty(name={"apiml.service.gateway.proxy.enabled"}, havingValue="true")
    public RouteLocator proxyRouteDefLocator(ReactiveDiscoveryClient discoveryClient, DiscoveryLocatorProperties properties, List<FilterDefinition> filters, ApplicationContext context, CorsUtils corsUtils) {
        return new ProxyRouteLocator(discoveryClient, properties, filters, context, corsUtils);
    }

    @Bean
    public List<FilterDefinition> filters() {
        FilterDefinition circuitBreakerFilter = new FilterDefinition();
        circuitBreakerFilter.setName("CircuitBreaker");
        FilterDefinition retryFilter = new FilterDefinition();
        retryFilter.setName("Retry");
        retryFilter.addArg("retries", "5");
        retryFilter.addArg("statuses", "SERVICE_UNAVAILABLE");
        ArrayList<FilterDefinition> filters = new ArrayList<FilterDefinition>();
        filters.add(circuitBreakerFilter);
        filters.add(retryFilter);
        for (String headerName : this.ignoredHeadersWhenCorsEnabled.split(",")) {
            FilterDefinition removeHeaders = new FilterDefinition();
            removeHeaders.setName("RemoveRequestHeader");
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("name", headerName);
            removeHeaders.setArgs(args);
            filters.add(removeHeaders);
        }
        return filters;
    }
}

