/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.config;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JCircuitBreakerFactory;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.gateway.config.GlobalCorsProperties;
import org.springframework.cloud.gateway.config.HttpClientCustomizer;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.netflix.eureka.MutableDiscoveryClientOptionalArgs;
import org.springframework.cloud.util.ProxyUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.pattern.PathPatternParser;
import org.zowe.apiml.cloudgatewayservice.service.ProxyRouteLocator;
import org.zowe.apiml.cloudgatewayservice.service.RouteLocator;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.HttpsFactory;
import org.zowe.apiml.util.CorsUtils;
import reactor.netty.http.client.HttpClient;

@Configuration
public class HttpConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpConfig.class);
    @Value(value="${server.ssl.protocol:TLSv1.2}")
    private String protocol;
    @Value(value="${server.ssl.trustStore:#{null}}")
    private String trustStorePath;
    @Value(value="${server.ssl.trustStorePassword:#{null}}")
    private char[] trustStorePassword;
    @Value(value="${server.ssl.trustStoreType:PKCS12}")
    private String trustStoreType;
    @Value(value="${server.ssl.keyAlias:#{null}}")
    private String keyAlias;
    @Value(value="${server.ssl.keyStore:#{null}}")
    private String keyStorePath;
    @Value(value="${server.ssl.keyStorePassword:#{null}}")
    private char[] keyStorePassword;
    @Value(value="${server.ssl.keyPassword:#{null}}")
    private char[] keyPassword;
    @Value(value="${server.ssl.keyStoreType:PKCS12}")
    private String keyStoreType;
    @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifySslCertificatesOfServices;
    @Value(value="${apiml.security.ssl.nonStrictVerifySslCertificatesOfServices:false}")
    private boolean nonStrictVerifySslCertificatesOfServices;
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${server.ssl.trustStoreRequired:false}")
    private boolean trustStoreRequired;
    @Value(value="${eureka.client.serviceUrl.defaultZone}")
    private String eurekaServerUrl;
    @Value(value="${apiml.gateway.timeout:60}")
    private int requestTimeout;
    @Value(value="${apiml.service.corsEnabled:false}")
    private boolean corsEnabled;
    @Value(value="${apiml.service.ignoredHeadersWhenCorsEnabled:-}")
    private String ignoredHeadersWhenCorsEnabled;
    private final ApplicationContext context;

    public HttpConfig(ApplicationContext context) {
        this.context = context;
    }

    @Bean
    @Qualifier(value="apimlEurekaJerseyClient")
    EurekaJerseyClient getEurekaJerseyClient() {
        return this.factory().createEurekaJerseyClientBuilder(this.eurekaServerUrl, this.serviceId).build();
    }

    HttpsFactory factory() {
        HttpsConfig config = HttpsConfig.builder().protocol(this.protocol).verifySslCertificatesOfServices(this.verifySslCertificatesOfServices).nonStrictVerifySslCertificatesOfServices(this.nonStrictVerifySslCertificatesOfServices).trustStorePassword(this.trustStorePassword).trustStoreRequired(this.trustStoreRequired).trustStore(this.trustStorePath).trustStoreType(this.trustStoreType).keyAlias(this.keyAlias).keyStore(this.keyStorePath).keyPassword(this.keyPassword).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).build();
        log.info("Using HTTPS configuration: {}", (Object)config.toString());
        return new HttpsFactory(config);
    }

    @Bean
    HttpClientCustomizer secureCustomizer() {
        return httpClient -> httpClient.secure(b -> b.sslContext(this.sslContext()));
    }

    SslContext sslContext() {
        try {
            KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
            try (InputStream inStream = Files.newInputStream(Paths.get(this.keyStorePath, new String[0]), new OpenOption[0]);){
                keyStore.load(inStream, this.keyStorePassword);
            }
            KeyStore trustStore = KeyStore.getInstance(this.trustStoreType);
            try (InputStream inStream = Files.newInputStream(Paths.get(this.trustStorePath, new String[0]), new OpenOption[0]);){
                trustStore.load(inStream, this.trustStorePassword);
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.keyStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            return SslContextBuilder.forClient().keyManager(keyManagerFactory).trustManager(trustManagerFactory).build();
        }
        catch (Exception e) {
            log.error("Exception while creating SSL context", (Throwable)e);
            System.exit(1);
            return null;
        }
    }

    @Bean(destroyMethod="shutdown")
    @RefreshScope
    @ConditionalOnMissingBean(value={EurekaClient.class})
    public EurekaClient eurekaClient(ApplicationInfoManager manager, EurekaClientConfig config, @Qualifier(value="apimlEurekaJerseyClient") EurekaJerseyClient eurekaJerseyClient, @Autowired(required=false) HealthCheckHandler healthCheckHandler) {
        ApplicationInfoManager appManager = AopUtils.isAopProxy((Object)manager) ? (ApplicationInfoManager)ProxyUtils.getTargetObject((Object)manager) : manager;
        MutableDiscoveryClientOptionalArgs args = new MutableDiscoveryClientOptionalArgs();
        args.setEurekaJerseyClient(eurekaJerseyClient);
        CloudEurekaClient cloudEurekaClient = new CloudEurekaClient(appManager, config, (AbstractDiscoveryClientOptionalArgs)args, (ApplicationEventPublisher)this.context);
        cloudEurekaClient.registerHealthCheck(healthCheckHandler);
        return cloudEurekaClient;
    }

    @Bean
    @ConditionalOnProperty(name={"apiml.service.gateway.proxy.enabled"}, havingValue="false")
    public RouteLocator apimlDiscoveryRouteDefLocator(ReactiveDiscoveryClient discoveryClient, DiscoveryLocatorProperties properties, List<FilterDefinition> filters, ApplicationContext context, CorsUtils corsUtils) {
        return new RouteLocator(discoveryClient, properties, filters, context, corsUtils);
    }

    @Bean
    @ConditionalOnProperty(name={"apiml.service.gateway.proxy.enabled"}, havingValue="true")
    public RouteLocator proxyRouteDefLocator(ReactiveDiscoveryClient discoveryClient, DiscoveryLocatorProperties properties, List<FilterDefinition> filters, ApplicationContext context, CorsUtils corsUtils) {
        return new ProxyRouteLocator(discoveryClient, properties, filters, context, corsUtils);
    }

    @Bean
    public Customizer<ReactiveResilience4JCircuitBreakerFactory> defaultCustomizer() {
        return factory -> factory.configureDefault(id -> new Resilience4JConfigBuilder(id).circuitBreakerConfig(CircuitBreakerConfig.ofDefaults()).timeLimiterConfig(TimeLimiterConfig.custom().timeoutDuration(Duration.ofSeconds(this.requestTimeout)).build()).build());
    }

    @Bean
    public WebClient webClient() {
        HttpClient client = HttpClient.create().secure(ssl -> ssl.sslContext(this.sslContext()));
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(client)).build();
    }

    @Bean
    public List<FilterDefinition> filters() {
        FilterDefinition circuitBreakerFilter = new FilterDefinition();
        circuitBreakerFilter.setName("CircuitBreaker");
        FilterDefinition retryFilter = new FilterDefinition();
        retryFilter.setName("Retry");
        retryFilter.addArg("retries", "5");
        retryFilter.addArg("statuses", "SERVICE_UNAVAILABLE");
        ArrayList<FilterDefinition> filters = new ArrayList<FilterDefinition>();
        filters.add(circuitBreakerFilter);
        filters.add(retryFilter);
        for (String headerName : this.ignoredHeadersWhenCorsEnabled.split(",")) {
            FilterDefinition removeHeaders = new FilterDefinition();
            removeHeaders.setName("RemoveRequestHeader");
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("name", headerName);
            removeHeaders.setArgs(args);
            filters.add(removeHeaders);
        }
        return filters;
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource(RoutePredicateHandlerMapping handlerMapping, GlobalCorsProperties globalCorsProperties, CorsUtils corsUtils) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource(new PathPatternParser());
        source.setCorsConfigurations(globalCorsProperties.getCorsConfigurations());
        corsUtils.registerDefaultCorsConfiguration((arg_0, arg_1) -> ((UrlBasedCorsConfigurationSource)source).registerCorsConfiguration(arg_0, arg_1));
        handlerMapping.setCorsConfigurationSource((CorsConfigurationSource)source);
        return source;
    }

    @Bean
    public CorsUtils corsUtils() {
        return new CorsUtils(this.corsEnabled);
    }

    @Bean
    public MessageService messageService() {
        return YamlMessageServiceInstance.getInstance();
    }
}

