/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.StringUtils;
import org.zowe.apiml.eurekaservice.client.util.EurekaMetadataParser;
import org.zowe.apiml.product.routing.RoutedService;
import reactor.core.publisher.Flux;

public class RouteLocator
implements RouteDefinitionLocator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RouteLocator.class);
    private final DiscoveryLocatorProperties properties;
    private final String routeIdPrefix;
    private final SimpleEvaluationContext evalCtxt;
    private Flux<List<ServiceInstance>> serviceInstances;

    public RouteLocator(ReactiveDiscoveryClient discoveryClient, DiscoveryLocatorProperties properties) {
        this(discoveryClient.getClass().getSimpleName(), properties);
        this.serviceInstances = discoveryClient.getServices().flatMap(service -> discoveryClient.getInstances(service).collectList());
    }

    private RouteLocator(String discoveryClientName, DiscoveryLocatorProperties properties) {
        this.properties = properties;
        this.routeIdPrefix = StringUtils.hasText((String)properties.getRouteIdPrefix()) ? properties.getRouteIdPrefix() : discoveryClientName + "_";
        this.evalCtxt = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
    }

    public Flux<RouteDefinition> getRouteDefinitions() {
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression urlExpr = parser.parseExpression(this.properties.getUrlExpression());
        EurekaMetadataParser metadataParser = new EurekaMetadataParser();
        return this.serviceInstances.filter(instances -> !instances.isEmpty()).flatMap(Flux::fromIterable).collectMap(ServiceInstance::getServiceId).flatMapMany(map -> Flux.fromIterable(map.values())).map(instance -> {
            List routedServices = metadataParser.parseToListRoute(instance.getMetadata());
            ArrayList<RouteDefinition> definitionsForInstance = new ArrayList<RouteDefinition>();
            for (RoutedService service : routedServices) {
                RouteDefinition routeDefinition = this.buildRouteDefinition(urlExpr, (ServiceInstance)instance, service.getSubServiceId());
                PredicateDefinition predicate = new PredicateDefinition();
                predicate.setName("Path");
                String predicateValue = "/" + instance.getServiceId().toLowerCase() + "/" + service.getGatewayUrl() + "/**";
                predicate.addArg("pattern", predicateValue);
                routeDefinition.getPredicates().add(predicate);
                FilterDefinition filter = new FilterDefinition();
                filter.setName("RewritePath");
                filter.addArg("regexp", predicateValue.replace("/**", "/?(?<remaining>.*)"));
                filter.addArg("replacement", service.getServiceUrl() + "/${remaining}");
                routeDefinition.getFilters().add(filter);
                definitionsForInstance.add(routeDefinition);
            }
            return definitionsForInstance;
        }).flatMapIterable(list -> list);
    }

    protected RouteDefinition buildRouteDefinition(Expression urlExpr, ServiceInstance serviceInstance, String routeId) {
        String serviceId = serviceInstance.getServiceId();
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setId(this.routeIdPrefix + serviceId + routeId);
        String uri = (String)urlExpr.getValue((EvaluationContext)this.evalCtxt, (Object)serviceInstance, String.class);
        routeDefinition.setUri(URI.create(uri));
        routeDefinition.setMetadata(new LinkedHashMap(serviceInstance.getMetadata()));
        return routeDefinition;
    }
}

