/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.service;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.expression.Expression;
import org.zowe.apiml.cloudgatewayservice.service.RouteLocator;
import org.zowe.apiml.product.routing.RoutedService;

public class ProxyRouteLocator
extends RouteLocator {
    public ProxyRouteLocator(ReactiveDiscoveryClient discoveryClient, DiscoveryLocatorProperties properties, List<FilterDefinition> filters) {
        super(discoveryClient, properties, filters);
    }

    @Override
    protected void setProperties(RouteDefinition routeDefinition, ServiceInstance instance, RoutedService service) {
        PredicateDefinition predicate = new PredicateDefinition();
        predicate.setName("Header");
        predicate.addArg("header", "X-Request-Id");
        predicate.addArg("regexp", (instance.getServiceId() + instance.getHost()).toLowerCase(Locale.ROOT));
        routeDefinition.getPredicates().add(predicate);
        for (FilterDefinition filter : this.getFilters()) {
            routeDefinition.getFilters().add(filter);
        }
    }

    @Override
    protected RouteDefinition buildRouteDefinition(Expression urlExpr, ServiceInstance serviceInstance, String routeId) {
        String serviceId = serviceInstance.getInstanceId();
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setId(this.getRouteIdPrefix() + serviceId + routeId);
        String uri = String.format("%s://%s:%d", serviceInstance.getScheme(), serviceInstance.getHost(), serviceInstance.getPort());
        routeDefinition.setUri(URI.create(uri));
        routeDefinition.setMetadata(new LinkedHashMap(serviceInstance.getMetadata()));
        return routeDefinition;
    }
}

