/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public class RobinRoundIterator<T> {
    private final AtomicInteger lastIndex = new AtomicInteger(-1);

    public Iterator<T> getIterator(Collection<T> input) {
        int offset = this.lastIndex.updateAndGet(prev -> input.isEmpty() ? 0 : (prev + 1) % input.size());
        return new RoundIterator(input, offset);
    }

    private class RoundIterator
    implements Iterator<T> {
        private final Collection<T> collection;
        private int remaining;
        private Iterator<T> iteratorOriginal;

        private RoundIterator(Collection<T> collection, int offset) {
            this.collection = collection;
            this.iteratorOriginal = collection.iterator();
            this.remaining = collection.size();
            for (int i = 0; i < offset; ++i) {
                this.iteratorOriginal.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public T next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            --this.remaining;
            if (!this.iteratorOriginal.hasNext()) {
                this.iteratorOriginal = this.collection.iterator();
            }
            return this.iteratorOriginal.next();
        }
    }
}

