/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.service.scheme;

import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.stereotype.Component;
import org.zowe.apiml.auth.Authentication;
import org.zowe.apiml.auth.AuthenticationScheme;
import org.zowe.apiml.cloudgatewayservice.service.scheme.SchemeHandler;

@Component
public class HttpBasicPassticket
implements SchemeHandler {
    @Override
    public AuthenticationScheme getAuthenticationScheme() {
        return AuthenticationScheme.HTTP_BASIC_PASSTICKET;
    }

    @Override
    public void apply(ServiceInstance serviceInstance, RouteDefinition routeDefinition, Authentication auth) {
        FilterDefinition filterDef = new FilterDefinition();
        filterDef.setName("PassticketFilterFactory");
        filterDef.addArg("applicationName", auth.getApplid());
        filterDef.addArg("serviceId", StringUtils.lowerCase((String)serviceInstance.getServiceId()));
        routeDefinition.getFilters().add(filterDef);
    }
}

