/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import org.zowe.apiml.cloudgatewayservice.filters.AbstractAuthSchemeFactory;
import org.zowe.apiml.cloudgatewayservice.service.InstanceInfoService;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.ticket.TicketRequest;
import org.zowe.apiml.ticket.TicketResponse;
import reactor.core.publisher.Mono;

@Service
public class PassticketFilterFactory
extends AbstractAuthSchemeFactory<Config, TicketResponse, String> {
    private static final String TICKET_URL = "%s://%s:%s/%s/api/v1/auth/ticket";
    private static final ObjectWriter WRITER = new ObjectMapper().writer();

    public PassticketFilterFactory(@Qualifier(value="webClientClientCert") WebClient webClient, InstanceInfoService instanceInfoService, MessageService messageService) {
        super(Config.class, webClient, instanceInfoService, messageService);
    }

    @Override
    protected Class<TicketResponse> getResponseClass() {
        return TicketResponse.class;
    }

    @Override
    protected TicketResponse getResponseFor401() {
        return new TicketResponse();
    }

    @Override
    protected WebClient.RequestHeadersSpec<?> createRequest(ServiceInstance instance, String requestBody) {
        return ((WebClient.RequestBodySpec)this.webClient.post().uri(String.format(TICKET_URL, instance.getScheme(), instance.getHost(), instance.getPort(), instance.getServiceId().toLowerCase()), new Object[0])).bodyValue((Object)requestBody);
    }

    @Override
    protected Mono<Void> processResponse(ServerWebExchange exchange, GatewayFilterChain chain, TicketResponse response) {
        ServerHttpRequest request;
        if (response.getTicket() != null) {
            String encodedCredentials = Base64.getEncoder().encodeToString((response.getUserId() + ":" + response.getTicket()).getBytes(StandardCharsets.UTF_8));
            String headerValue = "Basic " + encodedCredentials;
            request = this.setRequestHeader(exchange, "Authorization", headerValue);
        } else {
            request = this.updateHeadersForError(exchange, "Invalid or missing authentication.");
        }
        exchange = exchange.mutate().request(request).build();
        return chain.filter(exchange);
    }

    public GatewayFilter apply(Config config) {
        try {
            return this.createGatewayFilter(config, WRITER.writeValueAsString((Object)new TicketRequest(config.getApplicationName())));
        }
        catch (JsonProcessingException e) {
            return (exchange, chain) -> {
                ServerHttpRequest request = this.updateHeadersForError(exchange, e.getMessage());
                return chain.filter(exchange.mutate().request(request).build());
            };
        }
    }

    public static class Config
    extends AbstractAuthSchemeFactory.AbstractConfig {
        private String applicationName;

        @Generated
        public Config() {
        }

        @Generated
        public String getApplicationName() {
            return this.applicationName;
        }

        @Generated
        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Generated
        public String toString() {
            return "PassticketFilterFactory.Config(applicationName=" + this.getApplicationName() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$applicationName = this.getApplicationName();
            String other$applicationName = other.getApplicationName();
            return !(this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $applicationName = this.getApplicationName();
            result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
            return result;
        }
    }
}

