/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class ClientCertFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientCertFilterFactory.class);
    public static final String CLIENT_CERT_HEADER = "Client-Cert";

    public ClientCertFilterFactory() {
        super(Config.class);
    }

    public GatewayFilter apply(Config config) {
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest().mutate().headers(headers -> {
                X509Certificate[] certificates;
                headers.remove((Object)CLIENT_CERT_HEADER);
                if (exchange.getRequest().getSslInfo() != null && (certificates = exchange.getRequest().getSslInfo().getPeerCertificates()) != null && certificates.length > 0) {
                    try {
                        String encodedCert = Base64.getEncoder().encodeToString(certificates[0].getEncoded());
                        exchange.getAttributes().put("apiml.useClientCert", Boolean.TRUE);
                        headers.add(CLIENT_CERT_HEADER, encodedCert);
                        log.debug("Incoming client certificate has been added to the {} header.", (Object)CLIENT_CERT_HEADER);
                    }
                    catch (CertificateEncodingException e) {
                        log.debug("Failed to encode the incoming client certificate. Error message: {}", (Object)e.getMessage());
                        headers.add("X-Zowe-Auth-Failure", "Invalid client certificate in request. Error message: " + e.getMessage());
                    }
                }
            }).build();
            return chain.filter(exchange.mutate().request(request).build());
        };
    }

    public static class Config {
    }
}

