/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import java.net.HttpCookie;
import lombok.Generated;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import org.zowe.apiml.cloudgatewayservice.filters.AbstractAuthSchemeFactory;
import org.zowe.apiml.cloudgatewayservice.service.InstanceInfoService;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.zaas.zosmf.ZosmfResponse;
import reactor.core.publisher.Mono;

@Service
public class ZosmfFilterFactory
extends AbstractAuthSchemeFactory<Config, ZosmfResponse, Object> {
    private static final String ZOSMF_URL = "%s://%s:%d/%s/zaas/zosmf";

    public ZosmfFilterFactory(WebClient webClient, InstanceInfoService instanceInfoService, MessageService messageService) {
        super(Config.class, webClient, instanceInfoService, messageService);
    }

    public GatewayFilter apply(Config config) {
        try {
            return this.createGatewayFilter(config, null);
        }
        catch (Exception e) {
            return (exchange, chain) -> {
                ServerHttpRequest request = this.updateHeadersForError(exchange, e.getMessage());
                return chain.filter(exchange.mutate().request(request).build());
            };
        }
    }

    @Override
    protected Class<ZosmfResponse> getResponseClass() {
        return ZosmfResponse.class;
    }

    @Override
    protected ZosmfResponse getResponseFor401() {
        return new ZosmfResponse();
    }

    @Override
    protected WebClient.RequestHeadersSpec<?> createRequest(ServiceInstance instance, Object data) {
        String zosmfTokensUrl = String.format(ZOSMF_URL, instance.getScheme(), instance.getHost(), instance.getPort(), instance.getServiceId().toLowerCase());
        return this.webClient.post().uri(zosmfTokensUrl, new Object[0]);
    }

    @Override
    protected Mono<Void> processResponse(ServerWebExchange exchange, GatewayFilterChain chain, ZosmfResponse response) {
        ServerHttpRequest request = response.getToken() != null ? exchange.getRequest().mutate().headers(headers -> headers.add("Cookie", new HttpCookie(response.getCookieName(), response.getToken()).toString())).build() : this.updateHeadersForError(exchange, "Invalid or missing authentication.");
        exchange = exchange.mutate().request(request).build();
        return chain.filter(exchange);
    }

    public static class Config
    extends AbstractAuthSchemeFactory.AbstractConfig {
        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }
}

