/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.ssl.SslContext;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.client.WebClient;
import org.zowe.apiml.cloudgatewayservice.service.WebClientHelper;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;
import org.zowe.apiml.services.ServiceInfo;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.SslProvider;

@Service
public class GatewayIndexService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewayIndexService.class);
    private final ApimlLogger apimlLog = ApimlLogger.of(GatewayIndexService.class, (MessageService)YamlMessageServiceInstance.getInstance());
    private final Cache<String, ServiceInstance> apimlGatewayLookup;
    private final Cache<String, List<ServiceInfo>> apimlServicesCache;
    private final WebClient defaultWebClient;
    private SslContext customClientSslContext = null;

    public GatewayIndexService(WebClient defaultWebClient, @Value(value="${apiml.cloudGateway.cachePeriodSec:120}") int cachePeriodSec, @Value(value="${apiml.cloudGateway.clientKeystore:#{null}}") String clientKeystorePath, @Value(value="${apiml.cloudGateway.clientKeystorePassword:#{null}}") char[] clientKeystorePassword, @Value(value="${apiml.cloudGateway.clientKeystoreType:PKCS12}") String keystoreType) {
        this.defaultWebClient = defaultWebClient;
        this.apimlGatewayLookup = CacheBuilder.newBuilder().expireAfterWrite((long)cachePeriodSec, TimeUnit.SECONDS).build();
        this.apimlServicesCache = CacheBuilder.newBuilder().expireAfterWrite((long)cachePeriodSec, TimeUnit.SECONDS).build();
        if (StringUtils.isNotBlank((String)clientKeystorePath) && Objects.nonNull(clientKeystorePassword)) {
            this.customClientSslContext = WebClientHelper.load(clientKeystorePath, clientKeystorePassword, keystoreType);
        }
    }

    private WebClient buildWebClient(ServiceInstance registration) {
        String baseUrl = String.format("%s://%s:%d", registration.getScheme(), registration.getHost(), registration.getPort());
        if (this.customClientSslContext != null) {
            SslProvider sslProvider = SslProvider.builder().sslContext(this.customClientSslContext).build();
            HttpClient httpClient = HttpClient.create().secure(sslProvider);
            return WebClient.builder().baseUrl(baseUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).defaultHeader("Accept", new String[]{"application/json"}).build();
        }
        return this.defaultWebClient.mutate().baseUrl(baseUrl).build();
    }

    public Mono<List<ServiceInfo>> indexGatewayServices(ServiceInstance registration) {
        String apimlIdKey = this.extractApimlId(registration).orElse(this.buildAlternativeApimlIdKey(registration));
        log.debug("Fetching registered gateway instance services: {}", (Object)apimlIdKey);
        this.apimlGatewayLookup.put((Object)apimlIdKey, (Object)registration);
        return this.fetchServices(apimlIdKey, registration).doOnError(ex -> this.apimlLog.log("org.zowe.apiml.gateway.servicesRequestFailed", new Object[]{apimlIdKey, ex.getMessage()})).onErrorComplete().doFinally(signal -> log.debug("\t {} completed with {}", (Object)apimlIdKey, signal));
    }

    public void putApimlServices(@NotNull String apimlId, List<ServiceInfo> services) {
        this.apimlServicesCache.put((Object)apimlId, services);
    }

    private Mono<List<ServiceInfo>> fetchServices(String apimlId, ServiceInstance registration) {
        WebClient webClient = this.buildWebClient(registration);
        ParameterizedTypeReference<List<ServiceInfo>> serviceInfoType = new ParameterizedTypeReference<List<ServiceInfo>>(){};
        return webClient.get().uri("/gateway/services", new Object[0]).retrieve().bodyToMono((ParameterizedTypeReference)serviceInfoType).doOnNext(foreignServices -> this.apimlServicesCache.put((Object)apimlId, foreignServices));
    }

    private String buildAlternativeApimlIdKey(ServiceInstance registration) {
        return "SUBSTITUTE_" + registration.getInstanceId();
    }

    private Optional<String> extractApimlId(ServiceInstance registration) {
        return Optional.ofNullable(registration.getMetadata()).map(m -> (String)m.get("apiml.service.apimlId"));
    }

    public Map<String, List<ServiceInfo>> listRegistry(String apimlId, String apiId) {
        ImmutableMap allServices = ImmutableMap.builder().putAll((Map)this.apimlServicesCache.asMap()).build();
        return allServices.entrySet().stream().filter(entry -> apimlId == null || StringUtils.equals((String)apimlId, (String)((String)entry.getKey()))).map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), this.filterServicesByApiId((List)entry.getValue(), apiId))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    List<ServiceInfo> filterServicesByApiId(List<ServiceInfo> apimlIdServices, String apiId) {
        if (!CollectionUtils.isEmpty(apimlIdServices)) {
            return apimlIdServices.stream().filter(Objects::nonNull).filter(serviceInfo -> apiId == null || this.hasSameApiId((ServiceInfo)serviceInfo, apiId)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean hasSameApiId(ServiceInfo serviceInfo, String apiId) {
        if (serviceInfo.getApiml() != null && !CollectionUtils.isEmpty((Collection)serviceInfo.getApiml().getApiInfo())) {
            return StringUtils.equals((String)apiId, (String)((ServiceInfo.ApiInfoExtended)serviceInfo.getApiml().getApiInfo().get(0)).getApiId());
        }
        return false;
    }
}

