/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.config;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.security.KeyStore;
import java.time.Duration;
import javax.annotation.PostConstruct;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JCircuitBreakerFactory;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.gateway.config.GlobalCorsProperties;
import org.springframework.cloud.gateway.config.HttpClientCustomizer;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.netflix.eureka.MutableDiscoveryClientOptionalArgs;
import org.springframework.cloud.util.ProxyUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.pattern.PathPatternParser;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.message.yaml.YamlMessageService;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.HttpsConfigError;
import org.zowe.apiml.security.HttpsFactory;
import org.zowe.apiml.security.SecurityUtils;
import org.zowe.apiml.util.CorsUtils;
import reactor.netty.http.client.HttpClient;

@Configuration
public class ConnectionsConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionsConfig.class);
    private static final char[] KEYRING_PASSWORD = "password".toCharArray();
    @Value(value="${server.ssl.protocol:TLSv1.2}")
    private String protocol;
    @Value(value="${server.ssl.trustStore:#{null}}")
    private String trustStorePath;
    @Value(value="${server.ssl.trustStorePassword:#{null}}")
    private char[] trustStorePassword;
    @Value(value="${server.ssl.trustStoreType:PKCS12}")
    private String trustStoreType;
    @Value(value="${server.ssl.keyAlias:#{null}}")
    private String keyAlias;
    @Value(value="${server.ssl.keyStore:#{null}}")
    private String keyStorePath;
    @Value(value="${server.ssl.keyStorePassword:#{null}}")
    private char[] keyStorePassword;
    @Value(value="${server.ssl.keyPassword:#{null}}")
    private char[] keyPassword;
    @Value(value="${server.ssl.keyStoreType:PKCS12}")
    private String keyStoreType;
    @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifySslCertificatesOfServices;
    @Value(value="${apiml.security.ssl.nonStrictVerifySslCertificatesOfServices:false}")
    private boolean nonStrictVerifySslCertificatesOfServices;
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${server.ssl.trustStoreRequired:false}")
    private boolean trustStoreRequired;
    @Value(value="${eureka.client.serviceUrl.defaultZone}")
    private String eurekaServerUrl;
    @Value(value="${apiml.gateway.timeout:60}")
    private int requestTimeout;
    @Value(value="${apiml.service.corsEnabled:false}")
    private boolean corsEnabled;
    private final ApplicationContext context;
    private static final ApimlLogger apimlLog = ApimlLogger.of(ConnectionsConfig.class, (MessageService)YamlMessageServiceInstance.getInstance());

    public ConnectionsConfig(ApplicationContext context) {
        this.context = context;
    }

    @PostConstruct
    public void updateConfigParameters() {
        if (SecurityUtils.isKeyring((String)this.keyStorePath)) {
            this.keyStorePath = SecurityUtils.formatKeyringUrl((String)this.keyStorePath);
            if (this.keyStorePassword == null) {
                this.keyStorePassword = KEYRING_PASSWORD;
            }
        }
        if (SecurityUtils.isKeyring((String)this.trustStorePath)) {
            this.trustStorePath = SecurityUtils.formatKeyringUrl((String)this.trustStorePath);
            if (this.trustStorePassword == null) {
                this.trustStorePassword = KEYRING_PASSWORD;
            }
        }
    }

    @Bean
    @Qualifier(value="apimlEurekaJerseyClient")
    EurekaJerseyClient getEurekaJerseyClient() {
        return this.factory().createEurekaJerseyClientBuilder(this.eurekaServerUrl, this.serviceId).build();
    }

    HttpsFactory factory() {
        HttpsConfig config = HttpsConfig.builder().protocol(this.protocol).verifySslCertificatesOfServices(this.verifySslCertificatesOfServices).nonStrictVerifySslCertificatesOfServices(this.nonStrictVerifySslCertificatesOfServices).trustStorePassword(this.trustStorePassword).trustStoreRequired(this.trustStoreRequired).trustStore(this.trustStorePath).trustStoreType(this.trustStoreType).keyAlias(this.keyAlias).keyStore(this.keyStorePath).keyPassword(this.keyPassword).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).build();
        log.info("Using HTTPS configuration: {}", (Object)config.toString());
        return new HttpsFactory(config);
    }

    @Bean
    HttpClientCustomizer secureCustomizer() {
        return httpClient -> httpClient.secure(b -> b.sslContext(this.sslContext()));
    }

    SslContext sslContext() {
        try {
            KeyStore keyStore = SecurityUtils.loadKeyStore((String)this.keyStoreType, (String)this.keyStorePath, (char[])this.keyStorePassword);
            KeyStore trustStore = SecurityUtils.loadKeyStore((String)this.trustStoreType, (String)this.trustStorePath, (char[])this.trustStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.keyStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            return SslContextBuilder.forClient().keyManager(keyManagerFactory).trustManager(trustManagerFactory).build();
        }
        catch (Exception e) {
            apimlLog.log("org.zowe.apiml.common.sslContextInitializationError", new Object[]{e.getMessage()});
            throw new HttpsConfigError("Error initializing SSL Context: " + e.getMessage(), (Throwable)e, HttpsConfigError.ErrorCode.HTTP_CLIENT_INITIALIZATION_FAILED, this.factory().getConfig());
        }
    }

    @Bean(destroyMethod="shutdown")
    @RefreshScope
    @ConditionalOnMissingBean(value={EurekaClient.class})
    public EurekaClient eurekaClient(ApplicationInfoManager manager, EurekaClientConfig config, @Qualifier(value="apimlEurekaJerseyClient") EurekaJerseyClient eurekaJerseyClient, @Autowired(required=false) HealthCheckHandler healthCheckHandler) {
        ApplicationInfoManager appManager = AopUtils.isAopProxy((Object)manager) ? (ApplicationInfoManager)ProxyUtils.getTargetObject((Object)manager) : manager;
        MutableDiscoveryClientOptionalArgs args = new MutableDiscoveryClientOptionalArgs();
        args.setEurekaJerseyClient(eurekaJerseyClient);
        CloudEurekaClient cloudEurekaClient = new CloudEurekaClient(appManager, config, (AbstractDiscoveryClientOptionalArgs)args, (ApplicationEventPublisher)this.context);
        cloudEurekaClient.registerHealthCheck(healthCheckHandler);
        return cloudEurekaClient;
    }

    @Bean
    public Customizer<ReactiveResilience4JCircuitBreakerFactory> defaultCustomizer() {
        return factory -> factory.configureDefault(id -> new Resilience4JConfigBuilder(id).circuitBreakerConfig(CircuitBreakerConfig.ofDefaults()).timeLimiterConfig(TimeLimiterConfig.custom().timeoutDuration(Duration.ofSeconds(this.requestTimeout)).build()).build());
    }

    @Bean
    public WebClient webClient() {
        HttpClient client = HttpClient.create().secure(ssl -> ssl.sslContext(this.sslContext()));
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(client)).build();
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource(RoutePredicateHandlerMapping handlerMapping, GlobalCorsProperties globalCorsProperties, CorsUtils corsUtils) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource(new PathPatternParser());
        source.setCorsConfigurations(globalCorsProperties.getCorsConfigurations());
        corsUtils.registerDefaultCorsConfiguration((arg_0, arg_1) -> ((UrlBasedCorsConfigurationSource)source).registerCorsConfiguration(arg_0, arg_1));
        handlerMapping.setCorsConfigurationSource((CorsConfigurationSource)source);
        return source;
    }

    @Bean
    public CorsUtils corsUtils() {
        return new CorsUtils(this.corsEnabled);
    }

    @Bean
    public MessageService messageService() {
        YamlMessageService messageService = YamlMessageServiceInstance.getInstance();
        messageService.loadMessages("/cloud-gateway-log-messages.yml");
        return messageService;
    }
}

