/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ServerWebExchange;
import org.zowe.apiml.message.core.MessageService;

@Service
public class X509FilterFactory
extends AbstractGatewayFilterFactory<Config> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(X509FilterFactory.class);
    public static final String PUBLIC_KEY = "X-Certificate-Public";
    public static final String DISTINGUISHED_NAME = "X-Certificate-DistinguishedName";
    public static final String COMMON_NAME = "X-Certificate-CommonName";
    private final MessageService messageService;

    public X509FilterFactory(MessageService messageService) {
        super(Config.class);
        this.messageService = messageService;
    }

    public GatewayFilter apply(Config config) {
        return (exchange, chain) -> {
            X509Certificate[] certificates;
            if (exchange.getRequest().getSslInfo() != null && (certificates = exchange.getRequest().getSslInfo().getPeerCertificates()) != null && certificates.length > 0) {
                ServerHttpRequest request = exchange.getRequest().mutate().headers(headers -> {
                    try {
                        this.setHeader((HttpHeaders)headers, config.getHeaders().split(","), certificates[0]);
                    }
                    catch (CertificateEncodingException | InvalidNameException e) {
                        headers.add("X-Zowe-Auth-Failure", "Invalid client certificate in request. Error message: " + e.getMessage());
                    }
                }).build();
                return chain.filter(exchange.mutate().request(request).build());
            }
            return chain.filter(exchange.mutate().request(this.updateHeadersForError(exchange)).build());
        };
    }

    private ServerHttpRequest updateHeadersForError(ServerWebExchange exchange) {
        String headerValue = this.messageService.createMessage("org.zowe.apiml.gateway.security.schema.missingX509Authentication", new Object[0]).mapToLogMessage();
        ServerHttpRequest request = exchange.getRequest().mutate().header("X-Zowe-Auth-Failure", new String[]{headerValue}).build();
        exchange.getResponse().getHeaders().add("X-Zowe-Auth-Failure", headerValue);
        return request;
    }

    private void setHeader(HttpHeaders headers, String[] headerNames, X509Certificate certificate) throws CertificateEncodingException, InvalidNameException {
        block10: for (String headerName : headerNames) {
            switch (headerName.trim()) {
                case "X-Certificate-CommonName": {
                    headers.add(COMMON_NAME, X509FilterFactory.getCommonName(new LdapName(certificate.getSubjectDN().getName())));
                    continue block10;
                }
                case "X-Certificate-Public": {
                    headers.add(PUBLIC_KEY, Base64.getEncoder().encodeToString(certificate.getEncoded()));
                    continue block10;
                }
                case "X-Certificate-DistinguishedName": {
                    headers.add(DISTINGUISHED_NAME, certificate.getSubjectDN().getName());
                    continue block10;
                }
                default: {
                    log.debug("Unsupported header specified in service metadata, please review apiml.service.authentication.headers, possible values are: X-Certificate-Public, X-Certificate-DistinguishedName, X-Certificate-CommonName\nprovided value: " + headerName);
                }
            }
        }
    }

    public static String getCommonName(LdapName ldapDN) {
        for (Rdn rdn : ldapDN.getRdns()) {
            if (!"cn".equalsIgnoreCase(rdn.getType())) continue;
            return String.valueOf(rdn.getValue());
        }
        return null;
    }

    public static class Config {
        private String headers;

        public String getHeaders() {
            return this.headers;
        }

        public void setHeaders(String headers) {
            this.headers = headers;
        }
    }
}

