/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.cloudgatewayservice.filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import org.zowe.apiml.cloudgatewayservice.service.InstanceInfoService;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.ticket.TicketRequest;
import org.zowe.apiml.ticket.TicketResponse;
import reactor.core.publisher.Mono;

@Service
public class PassticketFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    private final WebClient webClient;
    private final InstanceInfoService instanceInfoService;
    private final MessageService messageService;
    private final String ticketUrl = "%s://%s:%s/%s/api/v1/auth/ticket";
    private final ObjectWriter writer = new ObjectMapper().writer();

    public PassticketFilterFactory(WebClient webClient, InstanceInfoService instanceInfoService, MessageService messageService) {
        super(Config.class);
        this.webClient = webClient;
        this.instanceInfoService = instanceInfoService;
        this.messageService = messageService;
    }

    public GatewayFilter apply(Config config) {
        try {
            String requestBody = this.writer.writeValueAsString((Object)new TicketRequest(config.getApplicationName()));
            return (exchange, chain) -> this.instanceInfoService.getServiceInstance("gateway").flatMap(instances -> {
                Iterator iterator = instances.iterator();
                if (iterator.hasNext()) {
                    ServiceInstance instance = (ServiceInstance)iterator.next();
                    return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(String.format("%s://%s:%s/%s/api/v1/auth/ticket", instance.getScheme(), instance.getHost(), instance.getPort(), instance.getServiceId().toLowerCase()), new Object[0])).headers(headers -> headers.addAll((MultiValueMap)exchange.getRequest().getHeaders()))).bodyValue((Object)requestBody).retrieve().onStatus(HttpStatus::is4xxClientError, response -> Mono.empty()).bodyToMono(TicketResponse.class).flatMap(response -> {
                        if (response.getTicket() == null) {
                            ServerHttpRequest request = this.updateHeadersForError(exchange, "Invalid or missing authentication.");
                            return chain.filter(exchange.mutate().request(request).build());
                        }
                        String encodedCredentials = Base64.getEncoder().encodeToString((response.getUserId() + ":" + response.getTicket()).getBytes(StandardCharsets.UTF_8));
                        String headerValue = "Basic " + encodedCredentials;
                        ServerHttpRequest request = this.addRequestHeader(exchange, "Authorization", headerValue);
                        return chain.filter(exchange.mutate().request(request).build());
                    });
                }
                ServerHttpRequest request = this.updateHeadersForError(exchange, "All gateway service instances failed to respond.");
                return chain.filter(exchange.mutate().request(request).build());
            });
        }
        catch (JsonProcessingException e) {
            return (exchange, chain) -> {
                ServerHttpRequest request = this.updateHeadersForError(exchange, e.getMessage());
                return chain.filter(exchange.mutate().request(request).build());
            };
        }
    }

    private ServerHttpRequest updateHeadersForError(ServerWebExchange exchange, String errorMessage) {
        ServerHttpRequest request = this.addRequestHeader(exchange, "X-Zowe-Auth-Failure", this.messageService.createMessage("org.zowe.apiml.security.ticket.generateFailed", new Object[]{errorMessage}).mapToLogMessage());
        exchange.getResponse().getHeaders().add("X-Zowe-Auth-Failure", this.messageService.createMessage("org.zowe.apiml.security.ticket.generateFailed", new Object[]{errorMessage}).mapToLogMessage());
        return request;
    }

    private ServerHttpRequest addRequestHeader(ServerWebExchange exchange, String key, String value) {
        return exchange.getRequest().mutate().headers(headers -> {
            headers.add(key, value);
            headers.remove((Object)"Cookie");
        }).build();
    }

    public static class Config {
        private String applicationName;

        public String getApplicationName() {
            return this.applicationName;
        }

        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }
    }
}

