/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.inmemory.config;

import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.zowe.apiml.cache.Storage;
import org.zowe.apiml.caching.service.inmemory.InMemoryStorage;
import org.zowe.apiml.caching.service.inmemory.config.InMemoryConfig;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;

@Configuration
public class InMemoryConfiguration {
    private final InMemoryConfig inMemoryConfig;

    @ConditionalOnProperty(name={"caching.storage.mode"}, havingValue="inMemory", matchIfMissing=true)
    @Bean
    public Storage inMemory(MessageService messageService) {
        ApimlLogger.of(InMemoryConfig.class, (MessageService)messageService).log("org.zowe.apiml.cache.usingInMemory", new Object[0]);
        return new InMemoryStorage(this.inMemoryConfig, messageService);
    }

    @Generated
    public InMemoryConfiguration(InMemoryConfig inMemoryConfig) {
        this.inMemoryConfig = inMemoryConfig;
    }
}

