/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.health;

import java.util.HashMap;
import lombok.Generated;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.embedded.provider.SpringEmbeddedCacheManager;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"caching.storage.mode"}, havingValue="infinispan")
public class CachesHealthIndicator
extends AbstractHealthIndicator {
    private final CacheManager cacheManager;

    protected void doHealthCheck(Health.Builder builder) {
        boolean health = true;
        CacheManager cacheManager = this.cacheManager;
        if (cacheManager instanceof SpringEmbeddedCacheManager) {
            SpringEmbeddedCacheManager springEmbeddedCacheManager = (SpringEmbeddedCacheManager)cacheManager;
            EmbeddedCacheManager nativeCacheManager = springEmbeddedCacheManager.getNativeCacheManager();
            ComponentStatus status = nativeCacheManager.getStatus();
            HashMap<String, Object> infinispan = new HashMap<String, Object>();
            infinispan.put("status", status);
            health &= status.allowInvocations();
            HashMap<String, ComponentStatus> caches = new HashMap<String, ComponentStatus>();
            for (String cacheName : this.cacheManager.getCacheNames()) {
                ComponentStatus cacheStatus = nativeCacheManager.getCache(cacheName).getStatus();
                caches.put(cacheName, cacheStatus);
                health &= cacheStatus.allowInvocations();
            }
            infinispan.put("caches", caches);
            builder.withDetail("infinispan", infinispan);
        }
        builder.status(health ? Status.UP : Status.DOWN);
    }

    @Generated
    public CachesHealthIndicator(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

