/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.redis.config;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslOptions;
import java.io.File;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.zowe.apiml.cache.Storage;
import org.zowe.apiml.caching.service.redis.RedisOperator;
import org.zowe.apiml.caching.service.redis.RedisStorage;
import org.zowe.apiml.caching.service.redis.config.RedisConfig;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;

@Configuration
@ConditionalOnProperty(name={"caching.storage.mode"}, havingValue="redis")
public class RedisConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisConfiguration.class);
    private final RedisConfig redisConfig;

    @Bean
    public Storage redis(MessageService messageService) {
        log.info("Using redis configuration {}", (Object)this.redisConfig);
        RedisURI redisUri = this.createRedisUri();
        RedisClient redisClient = this.createRedisClient();
        return new RedisStorage(new RedisOperator(redisClient, redisUri, ApimlLogger.of(RedisOperator.class, (MessageService)messageService)));
    }

    RedisURI createRedisUri() {
        RedisURI.Builder uriBuilder = RedisURI.builder().withSsl(this.redisConfig.usesSsl()).withAuthentication(this.redisConfig.getUsername(), this.redisConfig.getPassword()).withTimeout(Duration.ofSeconds(this.redisConfig.getTimeout().intValue()));
        if (this.redisConfig.usesSentinel()) {
            RedisConfig.Sentinel sentinelConfig = this.redisConfig.getSentinel();
            uriBuilder.withSentinelMasterId(sentinelConfig.getMasterInstance());
            for (RedisConfig.Sentinel.SentinelNode sentinelNode : sentinelConfig.getNodes()) {
                uriBuilder.withSentinel(sentinelNode.getHost(), sentinelNode.getPort().intValue(), (CharSequence)new String(sentinelNode.getPassword()));
            }
        } else {
            uriBuilder.withHost(this.redisConfig.getHost()).withPort(this.redisConfig.getPort().intValue());
        }
        return uriBuilder.build();
    }

    RedisClient createRedisClient() {
        RedisClient redisClient = RedisClient.create();
        if (this.redisConfig.usesSsl()) {
            RedisConfig.SslConfig sslConfig = this.redisConfig.getSsl();
            SslOptions sslOptions = SslOptions.builder().jdkSslProvider().keystore(new File(sslConfig.getKeyStore()), sslConfig.getKeyStorePassword().toCharArray()).truststore(new File(sslConfig.getTrustStore()), sslConfig.getTrustStorePassword()).build();
            redisClient.setOptions(ClientOptions.builder().sslOptions(sslOptions).build());
        }
        return redisClient;
    }

    @Generated
    public RedisConfiguration(RedisConfig redisConfig) {
        this.redisConfig = redisConfig;
    }
}

