/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.vsam;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.Messages;
import org.zowe.apiml.caching.service.StorageException;
import org.zowe.apiml.caching.service.vsam.VsamKey;
import org.zowe.apiml.caching.service.vsam.VsamRecordException;
import org.zowe.apiml.caching.service.vsam.config.VsamConfig;

public class VsamRecord {
    private final VsamConfig config;
    private String serviceId;
    private VsamKey key;
    private KeyValue keyValue;
    private ObjectMapper mapper = new ObjectMapper();
    private static final String UNSUPPORTED_ENCODING_MESSAGE = "Unsupported encoding: ";

    public VsamRecord(VsamConfig config, String serviceId, KeyValue kv) {
        this.config = config;
        this.serviceId = serviceId;
        this.keyValue = kv;
        this.key = new VsamKey(config);
    }

    public VsamRecord(VsamConfig config, byte[] recordData) throws VsamRecordException {
        this.config = config;
        this.key = new VsamKey(config);
        try {
            String recordString = new String(recordData, config.getEncoding());
            this.keyValue = (KeyValue)this.mapper.readValue(recordString.substring(config.getKeyLength()).trim(), KeyValue.class);
            this.serviceId = this.keyValue.getServiceId();
        }
        catch (UnsupportedEncodingException e) {
            throw new VsamRecordException(UNSUPPORTED_ENCODING_MESSAGE + config.getEncoding(), e);
        }
        catch (JsonProcessingException e) {
            throw new VsamRecordException("Failure deserializing the record value to KeyValue object", e);
        }
    }

    public byte[] getBytes() throws VsamRecordException {
        try {
            byte[] bytes = StringUtils.rightPad((String)(this.key.getKey(this.serviceId, this.keyValue.getKey()) + this.mapper.writeValueAsString((Object)this.keyValue)), (int)this.config.getRecordLength()).getBytes(this.config.getEncoding());
            if (bytes.length > this.config.getRecordLength()) {
                throw new StorageException(Messages.PAYLOAD_TOO_LARGE.getKey(), Messages.PAYLOAD_TOO_LARGE.getStatus(), this.keyValue.getKey());
            }
            return bytes;
        }
        catch (UnsupportedEncodingException e) {
            throw new VsamRecordException(UNSUPPORTED_ENCODING_MESSAGE + this.config.getEncoding(), e);
        }
        catch (JsonProcessingException e) {
            throw new VsamRecordException("Failure serializing KeyValue object to Json: " + this.config.getEncoding(), e);
        }
    }

    public byte[] getKeyBytes() throws VsamRecordException {
        try {
            return this.key.getKeyBytes(this.serviceId, this.keyValue);
        }
        catch (UnsupportedEncodingException e) {
            throw new VsamRecordException(UNSUPPORTED_ENCODING_MESSAGE + this.config.getEncoding(), e);
        }
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public KeyValue getKeyValue() {
        return this.keyValue;
    }

    public String toString() {
        return "VsamRecord{config=" + this.config + ", serviceId='" + this.serviceId + "', key=" + this.key.getKey(this.serviceId, this.keyValue.getKey()) + ", keyValue=" + this.keyValue + "}";
    }
}

