/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.redis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Retryable;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.Messages;
import org.zowe.apiml.caching.service.Storage;
import org.zowe.apiml.caching.service.StorageException;
import org.zowe.apiml.caching.service.redis.RedisEntry;
import org.zowe.apiml.caching.service.redis.RedisOperator;
import org.zowe.apiml.caching.service.redis.exceptions.RedisOutOfMemoryException;
import org.zowe.apiml.caching.service.redis.exceptions.RetryableRedisException;

public class RedisStorage
implements Storage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisStorage.class);
    private final RedisOperator redis;

    public RedisStorage(RedisOperator redisOperator) {
        log.info("Using Redis for the cached data");
        this.redis = redisOperator;
    }

    @Override
    @Retryable(value={RetryableRedisException.class})
    public KeyValue create(String serviceId, KeyValue toCreate) {
        log.info("Creating entry: {}|{}|{}", new Object[]{serviceId, toCreate.getKey(), toCreate.getValue()});
        RedisEntry entryToCreate = new RedisEntry(serviceId, toCreate);
        try {
            boolean result = this.redis.create(entryToCreate);
            if (!result) {
                throw new StorageException(Messages.DUPLICATE_KEY.getKey(), Messages.DUPLICATE_KEY.getStatus(), toCreate.getKey(), serviceId);
            }
        }
        catch (RedisOutOfMemoryException e) {
            throw new StorageException(Messages.INSUFFICIENT_STORAGE.getKey(), Messages.INSUFFICIENT_STORAGE.getStatus(), new String[0]);
        }
        return toCreate;
    }

    @Override
    public KeyValue storeListItem(String serviceId, KeyValue toCreate) throws StorageException {
        throw new StorageException(Messages.INCOMPATIBLE_STORAGE_METHOD.getKey(), Messages.INCOMPATIBLE_STORAGE_METHOD.getStatus(), new String[0]);
    }

    @Override
    public Map<String, String> getAllMapItems(String serviceId, String key) throws StorageException {
        throw new StorageException(Messages.INCOMPATIBLE_STORAGE_METHOD.getKey(), Messages.INCOMPATIBLE_STORAGE_METHOD.getStatus(), new String[0]);
    }

    @Override
    @Retryable(value={RetryableRedisException.class})
    public KeyValue read(String serviceId, String key) {
        log.info("Reading entry: {}|{}", (Object)serviceId, (Object)key);
        RedisEntry result = this.redis.get(serviceId, key);
        if (result == null) {
            throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), key, serviceId);
        }
        return result.getEntry();
    }

    @Override
    @Retryable(value={RetryableRedisException.class})
    public KeyValue update(String serviceId, KeyValue toUpdate) {
        log.info("Updating entry: {}|{}|{}", new Object[]{serviceId, toUpdate.getKey(), toUpdate.getValue()});
        RedisEntry entryToUpdate = new RedisEntry(serviceId, toUpdate);
        try {
            boolean result = this.redis.update(entryToUpdate);
            if (!result) {
                throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), toUpdate.getKey(), serviceId);
            }
        }
        catch (RedisOutOfMemoryException e) {
            throw new StorageException(Messages.INSUFFICIENT_STORAGE.getKey(), Messages.INSUFFICIENT_STORAGE.getStatus(), new String[0]);
        }
        return toUpdate;
    }

    @Override
    @Retryable(value={RetryableRedisException.class})
    public KeyValue delete(String serviceId, String toDelete) {
        log.info("Deleting entry: {}|{}", (Object)serviceId, (Object)toDelete);
        RedisEntry entryToDelete = this.redis.get(serviceId, toDelete);
        boolean result = this.redis.delete(serviceId, toDelete);
        if (!result) {
            throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), toDelete, serviceId);
        }
        return entryToDelete.getEntry();
    }

    @Override
    @Retryable(value={RetryableRedisException.class})
    public Map<String, KeyValue> readForService(String serviceId) {
        log.info("Reading all entries: {}", (Object)serviceId);
        List<RedisEntry> redisResult = this.redis.get(serviceId);
        HashMap<String, KeyValue> readResult = new HashMap<String, KeyValue>();
        for (RedisEntry redisEntry : redisResult) {
            readResult.put(redisEntry.getEntry().getKey(), redisEntry.getEntry());
        }
        return readResult;
    }

    @Override
    public void deleteForService(String serviceId) {
        log.info("Deleting all entries: {}", (Object)serviceId);
        boolean result = this.redis.delete(serviceId);
        if (!result) {
            log.info("No entries were deleted for {}", (Object)serviceId);
        }
    }
}

