/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.inmemory;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.DefaultEvictionStrategy;
import org.zowe.apiml.caching.service.EvictionStrategy;
import org.zowe.apiml.caching.service.Messages;
import org.zowe.apiml.caching.service.RejectStrategy;
import org.zowe.apiml.caching.service.Storage;
import org.zowe.apiml.caching.service.StorageException;
import org.zowe.apiml.caching.service.Strategies;
import org.zowe.apiml.caching.service.inmemory.RemoveOldestStrategy;
import org.zowe.apiml.caching.service.inmemory.config.InMemoryConfig;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;

public class InMemoryStorage
implements Storage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryStorage.class);
    private Map<String, Map<String, KeyValue>> storage;
    private EvictionStrategy strategy = new DefaultEvictionStrategy();
    private InMemoryConfig config;

    public InMemoryStorage(InMemoryConfig inMemoryConfig, MessageService messageService) {
        this(inMemoryConfig, new ConcurrentHashMap<String, Map<String, KeyValue>>(), ApimlLogger.of(RejectStrategy.class, (MessageService)messageService));
    }

    protected InMemoryStorage(InMemoryConfig inMemoryConfig, Map<String, Map<String, KeyValue>> storage, ApimlLogger apimlLogger) {
        this.storage = storage;
        this.config = inMemoryConfig;
        String evictionStrategy = inMemoryConfig.getGeneralConfig().getEvictionStrategy();
        if (evictionStrategy.equals(Strategies.REJECT.getKey())) {
            this.strategy = new RejectStrategy(apimlLogger);
        } else if (evictionStrategy.equals(Strategies.REMOVE_OLDEST.getKey())) {
            this.strategy = new RemoveOldestStrategy(storage);
        }
    }

    @Override
    public KeyValue create(String serviceId, KeyValue toCreate) {
        log.info("Writing record: {}|{}|{}", new Object[]{serviceId, toCreate.getKey(), toCreate.getValue()});
        this.storage.computeIfAbsent(serviceId, k -> new HashMap());
        Map<String, KeyValue> serviceStorage = this.storage.get(serviceId);
        if (serviceStorage.containsKey(toCreate.getKey())) {
            throw new StorageException(Messages.DUPLICATE_KEY.getKey(), Messages.DUPLICATE_KEY.getStatus(), toCreate.getKey());
        }
        if (this.aboveThreshold()) {
            this.strategy.evict(toCreate.getKey());
        }
        serviceStorage.put(toCreate.getKey(), toCreate);
        return toCreate;
    }

    @Override
    public KeyValue storeListItem(String serviceId, KeyValue toCreate) throws StorageException {
        throw new StorageException(Messages.INCOMPATIBLE_STORAGE_METHOD.getKey(), Messages.INCOMPATIBLE_STORAGE_METHOD.getStatus(), new String[0]);
    }

    @Override
    public Map<String, String> getAllMapItems(String serviceId, String key) throws StorageException {
        throw new StorageException(Messages.INCOMPATIBLE_STORAGE_METHOD.getKey(), Messages.INCOMPATIBLE_STORAGE_METHOD.getStatus(), new String[0]);
    }

    @Override
    public KeyValue read(String serviceId, String key) {
        log.info("Reading Record: {}|{}|{}", new Object[]{serviceId, key, "-"});
        Map<String, KeyValue> serviceSpecificStorage = this.storage.get(serviceId);
        if (serviceSpecificStorage == null || !serviceSpecificStorage.containsKey(key)) {
            throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), key, serviceId);
        }
        return serviceSpecificStorage.get(key);
    }

    @Override
    public KeyValue update(String serviceId, KeyValue toUpdate) {
        log.info("Updating Record: {}|{}|{}", new Object[]{serviceId, toUpdate.getKey(), toUpdate.getValue()});
        String key = toUpdate.getKey();
        if (this.isKeyNotInCache(serviceId, key)) {
            throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), key, serviceId);
        }
        Map<String, KeyValue> serviceStorage = this.storage.get(serviceId);
        serviceStorage.put(key, toUpdate);
        return toUpdate;
    }

    @Override
    public KeyValue delete(String serviceId, String key) {
        log.info("Deleting Record: {}|{}|{}", new Object[]{serviceId, key, "-"});
        if (this.isKeyNotInCache(serviceId, key)) {
            throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), key, serviceId);
        }
        Map<String, KeyValue> serviceSpecificStorage = this.storage.get(serviceId);
        return serviceSpecificStorage.remove(key);
    }

    @Override
    public Map<String, KeyValue> readForService(String serviceId) {
        return this.storage.get(serviceId);
    }

    @Override
    public void deleteForService(String serviceId) {
        this.storage.remove(serviceId);
    }

    private boolean isKeyNotInCache(String serviceId, String keyToTest) {
        Map<String, KeyValue> serviceSpecificStorage = this.storage.get(serviceId);
        return serviceSpecificStorage == null || serviceSpecificStorage.get(keyToTest) == null;
    }

    private boolean aboveThreshold() {
        int currentSize = 0;
        for (Map.Entry<String, Map<String, KeyValue>> serviceStorage : this.storage.entrySet()) {
            currentSize += serviceStorage.getValue().size();
        }
        log.info("Current Size {}.", (Object)currentSize);
        return currentSize >= this.config.getGeneralConfig().getMaxDataSize();
    }
}

