/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.api;

import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.Messages;
import org.zowe.apiml.caching.service.Storage;
import org.zowe.apiml.caching.service.StorageException;
import org.zowe.apiml.message.core.Message;
import org.zowe.apiml.message.core.MessageService;

@RestController
@RequestMapping(value={"/api/v1"})
public class CachingController {
    private final Storage storage;
    private final MessageService messageService;

    @GetMapping(value={"/cache"}, produces={"application/json"})
    @Operation(summary="Retrieves all values in the cache", description="Values returned for the calling service")
    @ResponseBody
    @HystrixCommand
    public ResponseEntity<Object> getAllValues(HttpServletRequest request) {
        return this.getServiceId(request).map(s -> {
            try {
                return new ResponseEntity(this.storage.readForService((String)s), HttpStatus.OK);
            }
            catch (Exception exception) {
                return this.handleInternalError(exception, request.getRequestURL());
            }
        }).orElseGet(this::getUnauthorizedResponse);
    }

    @DeleteMapping(value={"/cache"}, produces={"application/json"})
    @Operation(summary="Delete all values for service from the cache", description="Will delete all key-value pairs for specific service")
    @ResponseBody
    @HystrixCommand
    public ResponseEntity<Object> deleteAllValues(HttpServletRequest request) {
        return this.getServiceId(request).map(s -> {
            try {
                this.storage.deleteForService((String)s);
                return new ResponseEntity(HttpStatus.OK);
            }
            catch (Exception exception) {
                return this.handleInternalError(exception, request.getRequestURL());
            }
        }).orElseGet(this::getUnauthorizedResponse);
    }

    private ResponseEntity<Object> getUnauthorizedResponse() {
        Messages missingCert = Messages.MISSING_CERTIFICATE;
        Message message = this.messageService.createMessage(missingCert.getKey(), new Object[]{"parameter"});
        return new ResponseEntity((Object)message.mapToView(), missingCert.getStatus());
    }

    @GetMapping(value={"/cache/{key}"}, produces={"application/json"})
    @Operation(summary="Retrieves a specific value in the cache", description="Value returned is for the provided {key}")
    @ResponseBody
    @HystrixCommand
    public ResponseEntity<Object> getValue(@PathVariable String key, HttpServletRequest request) {
        return this.keyRequest(this.storage::read, key, request, HttpStatus.OK);
    }

    @DeleteMapping(value={"/cache/{key}"}, produces={"application/json"})
    @Operation(summary="Delete key from the cache", description="Will delete key-value pair for the provided {key}")
    @ResponseBody
    @HystrixCommand
    public ResponseEntity<Object> delete(@PathVariable String key, HttpServletRequest request) {
        return this.keyRequest(this.storage::delete, key, request, HttpStatus.NO_CONTENT);
    }

    @PostMapping(value={"/cache"}, produces={"application/json"})
    @Operation(summary="Create a new key in the cache", description="A new key-value pair will be added to the cache")
    @ResponseBody
    @HystrixCommand
    public ResponseEntity<Object> createKey(@RequestBody KeyValue keyValue, HttpServletRequest request) {
        return this.keyValueRequest(this.storage::create, keyValue, request, HttpStatus.CREATED);
    }

    @PostMapping(value={"/cache-list"}, produces={"application/json"})
    @Operation(summary="Add a new list item in the cache", description="A new key-value pair will be added to the cache")
    @ResponseBody
    @HystrixCommand
    public ResponseEntity<Object> storeListItem(@RequestBody KeyValue keyValue, HttpServletRequest request) {
        return this.keyValueRequest(this.storage::storeListItem, keyValue, request, HttpStatus.CREATED);
    }

    @GetMapping(value={"/cache-list/{key}"}, produces={"application/json"})
    @Operation(summary="Retrieves all the list items in the cache", description="Values returned for the calling service")
    @ResponseBody
    @HystrixCommand
    public ResponseEntity<Object> getAllListItems(@PathVariable String key, HttpServletRequest request) {
        return this.getServiceId(request).map(s -> {
            try {
                return new ResponseEntity(this.storage.getAllMapItems((String)s, key), HttpStatus.OK);
            }
            catch (Exception exception) {
                return this.handleIncompatibleStorageMethod(exception, request.getRequestURL());
            }
        }).orElseGet(this::getUnauthorizedResponse);
    }

    @PutMapping(value={"/cache"}, produces={"application/json"})
    @Operation(summary="Update key in the cache", description="Value at the key in the provided key-value pair will be updated to the provided value")
    @ResponseBody
    @HystrixCommand
    public ResponseEntity<Object> update(@RequestBody KeyValue keyValue, HttpServletRequest request) {
        return this.keyValueRequest(this.storage::update, keyValue, request, HttpStatus.NO_CONTENT);
    }

    private ResponseEntity<Object> exceptionToResponse(StorageException exception) {
        Message message = this.messageService.createMessage(exception.getKey(), (Object[])exception.getParameters());
        return new ResponseEntity((Object)message.mapToView(), exception.getStatus());
    }

    private ResponseEntity<Object> keyRequest(KeyOperation keyOperation, String key, HttpServletRequest request, HttpStatus successStatus) {
        Optional<String> serviceId = this.getServiceId(request);
        if (!serviceId.isPresent()) {
            return this.getUnauthorizedResponse();
        }
        try {
            if (key == null) {
                this.keyNotInCache();
            }
            KeyValue pair = keyOperation.storageRequest(serviceId.get(), key);
            return new ResponseEntity((Object)pair, successStatus);
        }
        catch (StorageException exception) {
            return this.exceptionToResponse(exception);
        }
        catch (Exception exception) {
            return this.handleInternalError(exception, request.getRequestURL());
        }
    }

    private ResponseEntity<Object> keyValueRequest(KeyValueOperation keyValueOperation, KeyValue keyValue, HttpServletRequest request, HttpStatus successStatus) {
        Optional<String> serviceId = this.getServiceId(request);
        if (!serviceId.isPresent()) {
            return this.getUnauthorizedResponse();
        }
        try {
            this.checkForInvalidPayload(keyValue);
            keyValueOperation.storageRequest(serviceId.get(), keyValue);
            return new ResponseEntity(successStatus);
        }
        catch (StorageException exception) {
            return this.exceptionToResponse(exception);
        }
        catch (Exception exception) {
            return this.handleInternalError(exception, request.getRequestURL());
        }
    }

    private Optional<String> getServiceId(HttpServletRequest request) {
        Optional<String> certificateServiceId = this.getHeader(request, "X-Certificate-DistinguishedName");
        Optional<String> specificServiceId = this.getHeader(request, "X-CS-Service-ID");
        if (certificateServiceId.isPresent() && specificServiceId.isPresent()) {
            return Optional.of(certificateServiceId.get() + ", SERVICE=" + specificServiceId.get());
        }
        if (!specificServiceId.isPresent()) {
            return certificateServiceId;
        }
        return specificServiceId;
    }

    private Optional<String> getHeader(HttpServletRequest request, String headerName) {
        String serviceId = request.getHeader(headerName);
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            return Optional.empty();
        }
        return Optional.of(serviceId);
    }

    private ResponseEntity<Object> handleInternalError(Exception exception, StringBuffer requestURL) {
        Messages internalServerError = Messages.INTERNAL_SERVER_ERROR;
        Message message = this.messageService.createMessage(internalServerError.getKey(), new Object[]{requestURL, exception.getMessage(), exception.toString()});
        return new ResponseEntity((Object)message.mapToView(), internalServerError.getStatus());
    }

    private ResponseEntity<Object> handleIncompatibleStorageMethod(Exception exception, StringBuffer requestURL) {
        Messages internalServerError = Messages.INCOMPATIBLE_STORAGE_METHOD;
        Message message = this.messageService.createMessage(internalServerError.getKey(), new Object[]{requestURL, exception.getMessage(), exception.toString()});
        return new ResponseEntity((Object)message.mapToView(), internalServerError.getStatus());
    }

    private void keyNotInCache() {
        throw new StorageException(Messages.KEY_NOT_PROVIDED.getKey(), Messages.KEY_NOT_PROVIDED.getStatus(), new String[0]);
    }

    private void invalidPayload(String keyValue, String message) {
        throw new StorageException(Messages.INVALID_PAYLOAD.getKey(), Messages.INVALID_PAYLOAD.getStatus(), keyValue, message);
    }

    private void checkForInvalidPayload(KeyValue keyValue) {
        String key;
        if (keyValue == null) {
            this.invalidPayload(null, "No KeyValue provided in the payload");
        }
        if (keyValue.getValue() == null) {
            this.invalidPayload(keyValue.toString(), "No value provided in the payload");
        }
        if ((key = keyValue.getKey()) == null) {
            this.invalidPayload(keyValue.toString(), "No key provided in the payload");
        }
    }

    @Generated
    public CachingController(Storage storage, MessageService messageService) {
        this.storage = storage;
        this.messageService = messageService;
    }

    @FunctionalInterface
    static interface KeyValueOperation {
        public KeyValue storageRequest(String var1, KeyValue var2) throws StorageException;
    }

    @FunctionalInterface
    static interface KeyOperation {
        public KeyValue storageRequest(String var1, String var2);
    }
}

