/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.infinispan.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.Messages;
import org.zowe.apiml.caching.service.Storage;
import org.zowe.apiml.caching.service.StorageException;

public class InfinispanStorage
implements Storage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InfinispanStorage.class);
    private final ConcurrentMap<String, KeyValue> cache;

    public InfinispanStorage(ConcurrentMap<String, KeyValue> cache) {
        this.cache = cache;
    }

    @Override
    public KeyValue create(String serviceId, KeyValue toCreate) {
        toCreate.setServiceId(serviceId);
        log.info("Writing record: {}|{}|{}", new Object[]{serviceId, toCreate.getKey(), toCreate.getValue()});
        KeyValue serviceCache = this.cache.putIfAbsent(serviceId + toCreate.getKey(), toCreate);
        if (serviceCache != null) {
            throw new StorageException(Messages.DUPLICATE_KEY.getKey(), Messages.DUPLICATE_KEY.getStatus(), toCreate.getKey());
        }
        return null;
    }

    @Override
    public KeyValue read(String serviceId, String key) {
        log.info("Reading record for service {} under key {}", (Object)serviceId, (Object)key);
        KeyValue serviceCache = (KeyValue)this.cache.get(serviceId + key);
        if (serviceCache != null) {
            return serviceCache;
        }
        throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), key, serviceId);
    }

    @Override
    public KeyValue update(String serviceId, KeyValue toUpdate) {
        toUpdate.setServiceId(serviceId);
        log.info("Updating record for service {} under key {}", (Object)serviceId, (Object)toUpdate);
        KeyValue serviceCache = this.cache.put(serviceId + toUpdate.getKey(), toUpdate);
        if (serviceCache == null) {
            throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), toUpdate.getKey(), serviceId);
        }
        return toUpdate;
    }

    @Override
    public KeyValue delete(String serviceId, String toDelete) {
        log.info("Removing record for service {} under key {}", (Object)serviceId, (Object)toDelete);
        KeyValue entry = (KeyValue)this.cache.remove(serviceId + toDelete);
        if (entry != null) {
            return entry;
        }
        throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), toDelete, serviceId);
    }

    @Override
    public Map<String, KeyValue> readForService(String serviceId) {
        log.info("Reading all records for service {} ", (Object)serviceId);
        HashMap<String, KeyValue> result = new HashMap<String, KeyValue>();
        this.cache.forEach((key, value) -> {
            if (serviceId.equals(value.getServiceId())) {
                result.put(value.getKey(), (KeyValue)value);
            }
        });
        return result;
    }

    @Override
    public void deleteForService(String serviceId) {
        log.info("Removing all records for service {} ", (Object)serviceId);
        this.cache.forEach((key, value) -> {
            if (value.getServiceId().equals(serviceId)) {
                this.cache.remove(key);
            }
        });
    }
}

