/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apiml.security.client.service;

import com.ca.apiml.security.client.handler.RestResponseHandler;
import com.ca.apiml.security.common.config.AuthConfigurationProperties;
import com.ca.apiml.security.common.error.ErrorType;
import com.ca.apiml.security.common.token.QueryResponse;
import com.ca.mfaas.product.gateway.GatewayClient;
import com.ca.mfaas.product.gateway.GatewayConfigProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class GatewaySecurityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewaySecurityService.class);
    private final GatewayClient gatewayClient;
    private final AuthConfigurationProperties authConfigurationProperties;
    private final RestTemplate restTemplate;
    private final RestResponseHandler responseHandler;

    public Optional<String> login(String username, String password) {
        GatewayConfigProperties gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        String uri = String.format("%s://%s%s", gatewayConfigProperties.getScheme(), gatewayConfigProperties.getHostname(), this.authConfigurationProperties.getGatewayLoginEndpoint());
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode loginRequest = mapper.createObjectNode();
        loginRequest.put("username", username);
        loginRequest.put("password", password);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        try {
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, new HttpEntity((Object)loginRequest, (MultiValueMap)headers), String.class, new Object[0]);
            return this.extractToken(response.getHeaders().getFirst("Set-Cookie"));
        }
        catch (HttpClientErrorException | HttpServerErrorException | ResourceAccessException e) {
            this.responseHandler.handleBadResponse((Exception)e, ErrorType.BAD_CREDENTIALS, "Can not access Gateway service. Uri '{}' returned: {}", uri, e.getMessage());
            return Optional.empty();
        }
    }

    public QueryResponse query(String token) {
        GatewayConfigProperties gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        String uri = String.format("%s://%s%s", gatewayConfigProperties.getScheme(), gatewayConfigProperties.getHostname(), this.authConfigurationProperties.getGatewayQueryEndpoint());
        String cookie = String.format("%s=%s", this.authConfigurationProperties.getCookieProperties().getCookieName(), token);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cookie", cookie);
        try {
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), QueryResponse.class, new Object[0]);
            return (QueryResponse)response.getBody();
        }
        catch (HttpClientErrorException | HttpServerErrorException | ResourceAccessException e) {
            this.responseHandler.handleBadResponse((Exception)e, ErrorType.TOKEN_NOT_VALID, "Can not access Gateway service. Uri '{}' returned: {}", uri, e.getMessage());
            return null;
        }
    }

    private Optional<String> extractToken(String cookies) {
        String cookieName = this.authConfigurationProperties.getCookieProperties().getCookieName();
        if (cookies == null || cookies.isEmpty() || !cookies.contains(cookieName)) {
            return Optional.empty();
        }
        int end = cookies.indexOf(59);
        String cookie = end > 0 ? cookies.substring(0, end) : cookies;
        return Optional.of(cookie.replace(cookieName + "=", ""));
    }

    @Generated
    public GatewaySecurityService(GatewayClient gatewayClient, AuthConfigurationProperties authConfigurationProperties, RestTemplate restTemplate, RestResponseHandler responseHandler) {
        this.gatewayClient = gatewayClient;
        this.authConfigurationProperties = authConfigurationProperties;
        this.restTemplate = restTemplate;
        this.responseHandler = responseHandler;
    }
}

