/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apiml.security.client.handler;

import com.ca.apiml.security.common.error.AuthMethodNotSupportedException;
import com.ca.apiml.security.common.error.ErrorType;
import com.ca.apiml.security.common.error.ServiceNotAccessibleException;
import com.ca.apiml.security.common.token.TokenNotProvidedException;
import com.ca.apiml.security.common.token.TokenNotValidException;
import com.ca.mfaas.product.gateway.GatewayNotAvailableException;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;

@Component
public class RestResponseHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestResponseHandler.class);

    public void handleBadResponse(@NotNull Exception exception, ErrorType errorType, String genericLogErrorMessage, Object ... logParameters) {
        if (exception instanceof HttpClientErrorException) {
            this.handleHttpClientError(exception, errorType, genericLogErrorMessage, logParameters);
        } else {
            if (exception instanceof ResourceAccessException) {
                throw new GatewayNotAvailableException(ErrorType.GATEWAY_NOT_AVAILABLE.getDefaultMessage(), (Throwable)exception);
            }
            if (exception instanceof HttpServerErrorException) {
                HttpServerErrorException hseException = (HttpServerErrorException)((Object)exception);
                if (hseException.getStatusCode().equals((Object)HttpStatus.SERVICE_UNAVAILABLE)) {
                    throw new ServiceNotAccessibleException(ErrorType.SERVICE_UNAVAILABLE.getDefaultMessage(), (Throwable)exception);
                }
                throw hseException;
            }
        }
    }

    private void handleHttpClientError(@NotNull Exception exception, ErrorType errorType, String genericLogErrorMessage, Object ... logParameters) {
        HttpClientErrorException hceException = (HttpClientErrorException)((Object)exception);
        switch (hceException.getStatusCode()) {
            case UNAUTHORIZED: {
                if (errorType != null) {
                    if (errorType.equals((Object)ErrorType.BAD_CREDENTIALS)) {
                        throw new BadCredentialsException(errorType.getDefaultMessage(), (Throwable)exception);
                    }
                    if (errorType.equals((Object)ErrorType.TOKEN_NOT_VALID)) {
                        throw new TokenNotValidException(errorType.getDefaultMessage(), (Throwable)exception);
                    }
                    if (errorType.equals((Object)ErrorType.TOKEN_NOT_PROVIDED)) {
                        throw new TokenNotProvidedException(errorType.getDefaultMessage());
                    }
                }
                throw new BadCredentialsException(ErrorType.BAD_CREDENTIALS.getDefaultMessage(), (Throwable)exception);
            }
            case BAD_REQUEST: {
                throw new AuthenticationCredentialsNotFoundException(ErrorType.AUTH_CREDENTIALS_NOT_FOUND.getDefaultMessage(), (Throwable)exception);
            }
            case METHOD_NOT_ALLOWED: {
                throw new AuthMethodNotSupportedException(ErrorType.AUTH_METHOD_NOT_SUPPORTED.getDefaultMessage());
            }
        }
        this.addLogMessage(exception, genericLogErrorMessage, logParameters);
        throw new AuthenticationServiceException(ErrorType.AUTH_GENERAL.getDefaultMessage(), (Throwable)exception);
    }

    private void addLogMessage(Exception exception, String genericLogErrorMessage, Object ... logParameters) {
        if (genericLogErrorMessage != null) {
            if (logParameters.length > 0) {
                log.error(genericLogErrorMessage, logParameters);
            } else {
                log.error(genericLogErrorMessage, (Throwable)exception);
            }
        }
    }
}

