/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.enable.api;

import com.ca.mfaas.enable.services.LocalApiDocService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
@ConditionalOnProperty(prefix="eureka.instance.metadata-map.mfaas.discovery", value={"enableApiDoc"}, havingValue="true", matchIfMissing=true)
public class ApiDocController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiDocController.class);
    private final boolean apiDocEnabled;
    private String swaggerLocation;
    private LocalApiDocService localApiDocService;

    @Autowired
    public ApiDocController(@Value(value="${eureka.instance.metadata-map.mfaas.discovery.enableApiDoc:true}") boolean apiDocEnabled, @Value(value="${eureka.instance.metadata-map.mfaas.api-info.swagger.location:}") String swaggerLocation, LocalApiDocService localApiDocService) {
        this.apiDocEnabled = apiDocEnabled;
        this.swaggerLocation = swaggerLocation;
        this.localApiDocService = localApiDocService;
    }

    @GetMapping(value={"/api-doc"}, produces={"application/json;charset=UTF-8"})
    public String getApiDoc(@RequestParam(value="group", required=false) String apiDocGroup) throws IOException {
        if (this.swaggerLocation == null || this.swaggerLocation.isEmpty()) {
            return this.localApiDocService.getApiDoc(apiDocGroup);
        }
        return this.loadApiDocumentationFromStaticResourceFileAsJson();
    }

    private String loadApiDocumentationFromStaticResourceFileAsJson() throws IOException {
        log.debug("Loading Api Documentation from static resource: " + this.swaggerLocation);
        try {
            if (!this.swaggerLocation.startsWith("classpath:")) {
                this.swaggerLocation = "classpath:" + this.swaggerLocation.trim();
            }
            try {
                File file = ResourceUtils.getFile((String)this.swaggerLocation);
                if (!file.exists()) {
                    return this.loadDocumentationAsFileInJar();
                }
                return new String(Files.readAllBytes(file.toPath()));
            }
            catch (FileNotFoundException e) {
                return this.loadDocumentationAsFileInJar();
            }
        }
        catch (IOException e) {
            log.error("An exception occurred when attempting to retrieve swagger file: " + this.swaggerLocation + ". " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private String loadDocumentationAsFileInJar() throws IOException {
        log.debug("Loading Api Documentation from jar resource: " + this.swaggerLocation);
        ClassPathResource cpr = new ClassPathResource(this.swaggerLocation);
        try {
            byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)cpr.getInputStream());
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IOException("Cannot find Api Documentation (swagger) file: " + this.swaggerLocation);
        }
    }

    @GetMapping(value={"/api-doc/enabled"}, produces={"application/json;charset=UTF-8"})
    public boolean isApiDocEnabled() {
        return this.apiDocEnabled;
    }
}

