/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.eurekaservice.client.impl;

import com.ca.mfaas.config.ApiInfo;
import com.ca.mfaas.eurekaservice.client.ApiMediationClient;
import com.ca.mfaas.eurekaservice.client.config.ApiMediationServiceConfig;
import com.ca.mfaas.eurekaservice.client.config.Catalog;
import com.ca.mfaas.eurekaservice.client.config.EurekaClientConfiguration;
import com.ca.mfaas.eurekaservice.client.config.Route;
import com.ca.mfaas.eurekaservice.client.config.Ssl;
import com.ca.mfaas.eurekaservice.client.impl.ApimlEurekaInstanceConfig;
import com.ca.mfaas.eurekaservice.client.util.EurekaMetadataParser;
import com.ca.mfaas.exception.MetadataValidationException;
import com.ca.mfaas.exception.ServiceDefinitionException;
import com.ca.mfaas.security.HttpsConfig;
import com.ca.mfaas.security.HttpsFactory;
import com.ca.mfaas.util.UrlUtils;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ApiMediationClientImpl
implements ApiMediationClient {
    private EurekaClient eurekaClient;

    @Override
    public synchronized void register(ApiMediationServiceConfig config) throws ServiceDefinitionException {
        if (this.eurekaClient != null) {
            throw new ServiceDefinitionException("EurekaClient was previously registered for this instance of ApiMediationClient. Call your ApiMediationClient unregister() method before attempting other registration.");
        }
        EurekaClientConfiguration clientConfiguration = new EurekaClientConfiguration(config);
        try {
            ApplicationInfoManager infoManager = this.initializeApplicationInfoManager(config);
            this.eurekaClient = this.initializeEurekaClient(infoManager, (EurekaClientConfig)clientConfiguration, config);
        }
        catch (RuntimeException rte) {
            throw new ServiceDefinitionException("Registration was not successful due to unexpected RuntimeException: ", (Throwable)rte);
        }
    }

    @Override
    public synchronized void unregister() {
        if (this.eurekaClient != null) {
            this.eurekaClient.shutdown();
        }
        this.eurekaClient = null;
    }

    private EurekaClient initializeEurekaClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig clientConfig, ApiMediationServiceConfig config) {
        Ssl sslConfig = config.getSsl();
        HttpsConfig httpsConfig = HttpsConfig.builder().protocol(sslConfig.getProtocol()).keyAlias(sslConfig.getKeyAlias()).keyStore(sslConfig.getKeyStore()).keyPassword(sslConfig.getKeyPassword()).keyStorePassword(sslConfig.getKeyStorePassword()).keyStoreType(sslConfig.getKeyStoreType()).trustStore(sslConfig.getTrustStore()).trustStoreType(sslConfig.getTrustStoreType()).trustStorePassword(sslConfig.getTrustStorePassword()).verifySslCertificatesOfServices(Boolean.TRUE.equals(sslConfig.getVerifySslCertificatesOfServices())).build();
        HttpsFactory factory = new HttpsFactory(httpsConfig);
        EurekaJerseyClient eurekaJerseyClient = factory.createEurekaJerseyClientBuilder(config.getDiscoveryServiceUrls().get(0), config.getServiceId()).build();
        DiscoveryClient.DiscoveryClientOptionalArgs args = new DiscoveryClient.DiscoveryClientOptionalArgs();
        args.setEurekaJerseyClient(eurekaJerseyClient);
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
        return new DiscoveryClient(applicationInfoManager, clientConfig, (AbstractDiscoveryClientOptionalArgs)args);
    }

    private ApplicationInfoManager initializeApplicationInfoManager(ApiMediationServiceConfig config) throws ServiceDefinitionException {
        EurekaInstanceConfig eurekaInstanceConfig = this.createEurekaInstanceConfig(config);
        InstanceInfo instanceInformation = new EurekaConfigBasedInstanceInfoProvider(eurekaInstanceConfig).get();
        return new ApplicationInfoManager(eurekaInstanceConfig, instanceInformation);
    }

    private EurekaInstanceConfig createEurekaInstanceConfig(ApiMediationServiceConfig config) throws ServiceDefinitionException {
        int port;
        String hostname;
        URL baseUrl;
        ApimlEurekaInstanceConfig result = new ApimlEurekaInstanceConfig();
        try {
            baseUrl = new URL(config.getBaseUrl());
            hostname = baseUrl.getHost();
            port = baseUrl.getPort();
        }
        catch (MalformedURLException e) {
            String message = String.format("baseUrl: [%s] is not valid URL", config.getBaseUrl());
            throw new ServiceDefinitionException(message, (Throwable)e);
        }
        result.setInstanceId(String.format("%s:%s:%s", hostname, config.getServiceId(), port));
        result.setAppname(config.getServiceId());
        result.setAppGroupName(config.getServiceId());
        result.setHostName(hostname);
        result.setIpAddress(config.getServiceIpAddress());
        result.setInstanceEnabledOnit(true);
        result.setSecureVirtualHostName(config.getServiceId());
        result.setVirtualHostName(config.getServiceId());
        result.setStatusPageUrl(config.getBaseUrl() + config.getStatusPageRelativeUrl());
        if (config.getHomePageRelativeUrl() != null && !config.getHomePageRelativeUrl().isEmpty()) {
            result.setHomePageUrl(config.getBaseUrl() + config.getHomePageRelativeUrl());
        }
        String protocol = baseUrl.getProtocol();
        result.setNonSecurePort(port);
        result.setSecurePort(port);
        switch (protocol) {
            case "http": {
                result.setNonSecurePortEnabled(true);
                result.setHealthCheckUrl(config.getBaseUrl() + config.getHealthCheckRelativeUrl());
                break;
            }
            case "https": {
                result.setSecurePortEnabled(true);
                result.setSecureHealthCheckUrl(config.getBaseUrl() + config.getHealthCheckRelativeUrl());
                break;
            }
            default: {
                throw new ServiceDefinitionException(String.format("'%s' is not valid protocol for baseUrl property", protocol));
            }
        }
        try {
            result.setMetadataMap(this.createMetadata(config));
        }
        catch (MetadataValidationException e) {
            throw new ServiceDefinitionException("Service configuration failed: ", (Throwable)e);
        }
        return result;
    }

    private Map<String, String> createMetadata(ApiMediationServiceConfig config) {
        Catalog.Tile tile;
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (Route route : config.getRoutes()) {
            String gatewayUrl = UrlUtils.trimSlashes((String)route.getGatewayUrl());
            String serviceUrl = route.getServiceUrl();
            String key = gatewayUrl.replace("/", "-");
            metadata.put(String.format("%s.%s.%s", "apiml.routes", key, "gatewayUrl"), gatewayUrl);
            metadata.put(String.format("%s.%s.%s", "apiml.routes", key, "serviceUrl"), serviceUrl);
        }
        if (config.getCatalog() != null && (tile = config.getCatalog().getTile()) != null) {
            metadata.put("apiml.catalog.tile.id", tile.getId());
            metadata.put("apiml.catalog.tile.version", tile.getVersion());
            metadata.put("apiml.catalog.tile.title", tile.getTitle());
            metadata.put("apiml.catalog.tile.description", tile.getDescription());
        }
        metadata.put("apiml.service.title", config.getTitle());
        metadata.put("apiml.service.description", config.getDescription());
        for (ApiInfo apiInfo : config.getApiInfo()) {
            metadata.putAll(EurekaMetadataParser.generateMetadata((String)config.getServiceId(), (ApiInfo)apiInfo));
        }
        return metadata;
    }

    @Override
    public EurekaClient getEurekaClient() {
        return this.eurekaClient;
    }
}

