/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.eurekaservice.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.RandomStringUtils;

public class ApiInfo {
    @JsonProperty(required=true)
    private String apiId;
    private String gatewayUrl;
    private String version;
    private String swaggerUrl;
    private String documentationUrl;

    public Map<String, String> generateMetadata(String serviceId) {
        String encodedGatewayUrl;
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.gatewayUrl != null) {
            encodedGatewayUrl = this.gatewayUrl.replaceAll("\\W", "-");
            metadata.put(String.format("apiml.apiInfo.%s.gatewayUrl", encodedGatewayUrl), this.gatewayUrl);
        } else {
            encodedGatewayUrl = RandomStringUtils.randomAlphanumeric((int)10);
        }
        if (this.version != null) {
            metadata.put(String.format("apiml.apiInfo.%s.version", encodedGatewayUrl), this.version);
        }
        if (this.swaggerUrl != null) {
            try {
                new URL(this.swaggerUrl);
            }
            catch (MalformedURLException e) {
                throw new InvalidParameterException(String.format("The Swagger URL \"%s\" for service %s is not valid: %s", this.swaggerUrl, serviceId, e.getMessage()));
            }
            metadata.put(String.format("apiml.apiInfo.%s.swaggerUrl", encodedGatewayUrl), this.swaggerUrl);
        }
        if (this.documentationUrl != null) {
            try {
                new URL(this.documentationUrl);
            }
            catch (MalformedURLException e) {
                throw new InvalidParameterException(String.format("The documentation URL \"%s\" for service %s is not valid: %s", this.documentationUrl, serviceId, e.getMessage()));
            }
            metadata.put(String.format("apiml.apiInfo.%s.documentationUrl", encodedGatewayUrl), this.documentationUrl);
        }
        return metadata;
    }

    @Generated
    public ApiInfo() {
    }

    @Generated
    public ApiInfo(String apiId, String gatewayUrl, String version, String swaggerUrl, String documentationUrl) {
        this.apiId = apiId;
        this.gatewayUrl = gatewayUrl;
        this.version = version;
        this.swaggerUrl = swaggerUrl;
        this.documentationUrl = documentationUrl;
    }

    @Generated
    public String getApiId() {
        return this.apiId;
    }

    @Generated
    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getSwaggerUrl() {
        return this.swaggerUrl;
    }

    @Generated
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Generated
    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    @Generated
    public void setGatewayUrl(String gatewayUrl) {
        this.gatewayUrl = gatewayUrl;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setSwaggerUrl(String swaggerUrl) {
        this.swaggerUrl = swaggerUrl;
    }

    @Generated
    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiInfo)) {
            return false;
        }
        ApiInfo other = (ApiInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiId = this.getApiId();
        String other$apiId = other.getApiId();
        if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) {
            return false;
        }
        String this$gatewayUrl = this.getGatewayUrl();
        String other$gatewayUrl = other.getGatewayUrl();
        if (this$gatewayUrl == null ? other$gatewayUrl != null : !this$gatewayUrl.equals(other$gatewayUrl)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$swaggerUrl = this.getSwaggerUrl();
        String other$swaggerUrl = other.getSwaggerUrl();
        if (this$swaggerUrl == null ? other$swaggerUrl != null : !this$swaggerUrl.equals(other$swaggerUrl)) {
            return false;
        }
        String this$documentationUrl = this.getDocumentationUrl();
        String other$documentationUrl = other.getDocumentationUrl();
        return !(this$documentationUrl == null ? other$documentationUrl != null : !this$documentationUrl.equals(other$documentationUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiId = this.getApiId();
        result = result * 59 + ($apiId == null ? 43 : $apiId.hashCode());
        String $gatewayUrl = this.getGatewayUrl();
        result = result * 59 + ($gatewayUrl == null ? 43 : $gatewayUrl.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $swaggerUrl = this.getSwaggerUrl();
        result = result * 59 + ($swaggerUrl == null ? 43 : $swaggerUrl.hashCode());
        String $documentationUrl = this.getDocumentationUrl();
        result = result * 59 + ($documentationUrl == null ? 43 : $documentationUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiInfo(apiId=" + this.getApiId() + ", gatewayUrl=" + this.getGatewayUrl() + ", version=" + this.getVersion() + ", swaggerUrl=" + this.getSwaggerUrl() + ", documentationUrl=" + this.getDocumentationUrl() + ")";
    }
}

