/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.eurekaservice.client.impl;

import com.ca.mfaas.config.ApiInfo;
import com.ca.mfaas.eurekaservice.client.ApiMediationClient;
import com.ca.mfaas.eurekaservice.client.config.ApiMediationServiceConfig;
import com.ca.mfaas.eurekaservice.client.config.EurekaClientConfiguration;
import com.ca.mfaas.eurekaservice.client.config.Route;
import com.ca.mfaas.eurekaservice.client.config.Ssl;
import com.ca.mfaas.eurekaservice.client.impl.ApimlEurekaInstanceConfig;
import com.ca.mfaas.eurekaservice.client.util.StringUtils;
import com.ca.mfaas.eurekaservice.client.util.UrlUtils;
import com.ca.mfaas.security.HttpsConfig;
import com.ca.mfaas.security.HttpsFactory;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiMediationClientImpl
implements ApiMediationClient {
    private static final Logger log = LoggerFactory.getLogger(ApiMediationClientImpl.class);
    private EurekaClient eurekaClient;

    @Override
    public synchronized void register(ApiMediationServiceConfig config) {
        ApplicationInfoManager infoManager = this.initializeApplicationInfoManager(config);
        EurekaClientConfiguration clientConfiguration = new EurekaClientConfiguration(config);
        this.eurekaClient = this.initializeEurekaClient(infoManager, (EurekaClientConfig)clientConfiguration, config);
        log.debug("eurekaClient.getApplicationInfoManager().getInfo().getHostName(): {}", (Object)this.eurekaClient.getApplicationInfoManager().getInfo().getHostName());
    }

    @Override
    public synchronized void unregister() {
        if (this.eurekaClient != null) {
            this.eurekaClient.shutdown();
        }
    }

    private EurekaClient initializeEurekaClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig clientConfig, ApiMediationServiceConfig config) {
        Ssl sslConfig = config.getSsl();
        HttpsConfig httpsConfig = HttpsConfig.builder().protocol(sslConfig.getProtocol()).keyAlias(sslConfig.getKeyAlias()).keyStore(sslConfig.getKeyStore()).keyPassword(sslConfig.getKeyPassword()).keyStorePassword(sslConfig.getKeyStorePassword()).keyStoreType(sslConfig.getKeyStoreType()).trustStore(sslConfig.getTrustStore()).trustStoreType(sslConfig.getTrustStoreType()).trustStorePassword(sslConfig.getTrustStorePassword()).verifySslCertificatesOfServices(sslConfig.isVerifySslCertificatesOfServices()).build();
        HttpsFactory factory = new HttpsFactory(httpsConfig);
        EurekaJerseyClient eurekaJerseyClient = factory.createEurekaJerseyClientBuilder(config.getDiscoveryServiceUrls().get(0), config.getServiceId()).build();
        DiscoveryClient.DiscoveryClientOptionalArgs args = new DiscoveryClient.DiscoveryClientOptionalArgs();
        args.setEurekaJerseyClient(eurekaJerseyClient);
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
        return new DiscoveryClient(applicationInfoManager, clientConfig, (AbstractDiscoveryClientOptionalArgs)args);
    }

    private ApplicationInfoManager initializeApplicationInfoManager(ApiMediationServiceConfig config) {
        EurekaInstanceConfig eurekaInstanceConfig = this.createEurekaInstanceConfig(config);
        InstanceInfo instanceInformation = new EurekaConfigBasedInstanceInfoProvider(eurekaInstanceConfig).get();
        return new ApplicationInfoManager(eurekaInstanceConfig, instanceInformation);
    }

    private EurekaInstanceConfig createEurekaInstanceConfig(ApiMediationServiceConfig config) {
        int port;
        String hostname;
        URL baseUrl;
        ApimlEurekaInstanceConfig result = new ApimlEurekaInstanceConfig();
        try {
            baseUrl = new URL(config.getBaseUrl());
            hostname = baseUrl.getHost();
            port = baseUrl.getPort();
        }
        catch (MalformedURLException e) {
            String message = String.format("baseUrl: [%s] is not valid URL", config.getBaseUrl());
            throw new InvalidParameterException(message);
        }
        result.setInstanceId(String.format("%s:%s:%s", hostname, config.getServiceId(), port));
        result.setAppname(config.getServiceId());
        result.setHostName(hostname);
        result.setAppGroupName(null);
        result.setInstanceEnabledOnit(true);
        result.setSecureVirtualHostName(config.getServiceId());
        result.setVirtualHostName(config.getServiceId());
        result.setIpAddress(config.getEureka().getIpAddress());
        result.setMetadataMap(this.createMetadata(config));
        result.setStatusPageUrl(config.getBaseUrl() + config.getStatusPageRelativeUrl());
        if (!StringUtils.isNullOrEmpty(config.getHomePageRelativeUrl())) {
            result.setHomePageUrl(config.getBaseUrl() + config.getHomePageRelativeUrl());
        }
        String protocol = baseUrl.getProtocol();
        result.setNonSecurePort(port);
        result.setSecurePort(port);
        switch (protocol) {
            case "http": {
                result.setNonSecurePortEnabled(true);
                result.setHealthCheckUrl(config.getBaseUrl() + config.getHealthCheckRelativeUrl());
                break;
            }
            case "https": {
                result.setSecurePortEnabled(true);
                result.setSecureHealthCheckUrl(config.getBaseUrl() + config.getHealthCheckRelativeUrl());
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid protocol for baseUrl property");
            }
        }
        return result;
    }

    private Map<String, String> createMetadata(ApiMediationServiceConfig config) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (Route route : config.getRoutes()) {
            String gatewayUrl = UrlUtils.trimSlashes(route.getGatewayUrl());
            String serviceUrl = route.getServiceUrl();
            String key = gatewayUrl.replace("/", "-");
            metadata.put(String.format("routed-services.%s.gateway-url", key), gatewayUrl);
            metadata.put(String.format("routed-services.%s.service-url", key), serviceUrl);
        }
        if (config.getCatalogUiTile() != null) {
            metadata.put("mfaas.discovery.catalogUiTile.id", config.getCatalogUiTile().getId());
            metadata.put("mfaas.discovery.catalogUiTile.version", config.getCatalogUiTile().getVersion());
            metadata.put("mfaas.discovery.catalogUiTile.title", config.getCatalogUiTile().getTitle());
            metadata.put("mfaas.discovery.catalogUiTile.description", config.getCatalogUiTile().getDescription());
        }
        metadata.put("mfaas.discovery.service.title", config.getTitle());
        metadata.put("mfaas.discovery.service.description", config.getDescription());
        for (ApiInfo apiInfo : config.getApiInfo()) {
            metadata.putAll(apiInfo.generateMetadata(config.getServiceId()));
        }
        return metadata;
    }
}

