/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.eurekaservice.client.util;

import com.ca.mfaas.eurekaservice.client.config.ApiMediationServiceConfig;
import com.ca.mfaas.eurekaservice.client.util.ApiMediationServiceConfigReaderException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class ApiMediationServiceConfigReader {
    private final String fileName;

    public ApiMediationServiceConfigReader(String fileName) {
        this.fileName = fileName;
    }

    public ApiMediationServiceConfig readConfiguration() {
        ApiMediationServiceConfig configuration;
        URL fileUrl = this.getClass().getResource(this.fileName);
        if (fileUrl == null) {
            throw new ApiMediationServiceConfigReaderException(String.format("File [%s] is not exist", this.fileName));
        }
        File configFile = new File(fileUrl.getFile());
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            configuration = (ApiMediationServiceConfig)mapper.readValue(configFile, ApiMediationServiceConfig.class);
        }
        catch (IOException e) {
            throw new ApiMediationServiceConfigReaderException(String.format("File [%s] can't be parsed as ApiMediationServiceConfig", this.fileName));
        }
        return configuration;
    }
}

