/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class BuildInfoDetails {
    private final Properties build;
    private final Properties git;

    public BuildInfoDetails(Properties build, Properties git) {
        this.build = build;
        this.git = git;
    }

    public String getArtifact() {
        return this.build.get("build.artifact") == null ? "Unknown" : String.valueOf(this.build.get("build.artifact"));
    }

    public String getVersion() {
        return this.build.get("build.version") == null ? "Unknown" : String.valueOf(this.build.get("build.version"));
    }

    public String getNumber() {
        if (String.valueOf(this.build.get("build.number")).equals("n/a")) {
            return "n/a";
        }
        return String.valueOf(this.build.get("build.number"));
    }

    public Date getTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        Date date = null;
        try {
            date = dateFormat.parse(String.valueOf(this.build.get("build.time")));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public String getMachine() {
        return this.build.get("build.machine") == null ? "Unknown" : String.valueOf(this.build.get("build.machine"));
    }

    public String getCommitId() {
        return this.git.get("git.commit.id.abbrev") == null ? "Unknown" : String.valueOf(this.git.get("git.commit.id.abbrev"));
    }
}

