/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.service;

import com.ca.mfaas.product.service.BuildInfoDetails;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildInfo.class);

    public void logBuildInfo() {
        BuildInfoDetails buildInfo = this.getBuildInfoDetails();
        log.info("Service {} version {} #{} on {} by {} commit {}", new Object[]{buildInfo.getArtifact(), buildInfo.getVersion(), buildInfo.getNumber(), buildInfo.getTime(), buildInfo.getMachine(), buildInfo.getCommitId()});
    }

    public BuildInfoDetails getBuildInfoDetails() {
        Properties build = this.getProperties("META-INF/build-info.properties");
        Properties git = this.getProperties("META-INF/git.properties");
        return new BuildInfoDetails(build, git);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(String path) {
        Properties props = new Properties();
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(path);
        if (input == null) {
            log.error("Could not read properties from: {}", (Object)path);
            return props;
        }
        try {
            props.load(input);
        }
        catch (IOException ioe) {
            log.error("Error reading properties from: {} Details: {}", (Object)path, (Object)ioe.toString());
            Properties properties = props;
            return properties;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return props;
    }
}

