/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.routing;

import com.ca.mfaas.product.routing.RoutedService;
import com.ca.mfaas.product.routing.ServiceType;
import java.util.HashMap;
import java.util.Map;

public class RoutedServices {
    public static final String ROUTED_SERVICES_PARAMETER = "routed-services";
    public static final String GATEWAY_URL_PARAMETER = "gateway-url";
    public static final String SERVICE_URL_PARAMETER = "service-url";
    private final Map<String, RoutedService> routedService = new HashMap<String, RoutedService>();

    public void addRoutedService(RoutedService route) {
        this.routedService.put(route.getGatewayUrl(), route);
    }

    public RoutedService findServiceByGatewayUrl(String gatewayUrl) {
        return this.routedService.get(gatewayUrl);
    }

    public RoutedService getBestMatchingServiceUrl(String serviceUrl, ServiceType type) {
        RoutedService result = null;
        int maxSize = 0;
        for (String key : this.routedService.keySet()) {
            RoutedService value;
            int size;
            if (type.equals((Object)ServiceType.ALL) || !key.toLowerCase().startsWith(type.name().toLowerCase()) || (size = (value = this.routedService.get(key)).getServiceUrl().length()) <= maxSize || !serviceUrl.toLowerCase().startsWith(value.getServiceUrl().toLowerCase())) continue;
            result = value;
            maxSize = size;
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (Map.Entry<String, RoutedService> route : this.routedService.entrySet()) {
            builder.append(route.getKey());
            builder.append(" -> ");
            builder.append(route.toString());
            builder.append(", ");
        }
        if (this.routedService.size() > 0) {
            builder.setLength(builder.length() - 2);
        }
        builder.append("]");
        return builder.toString();
    }
}

