/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.version;

import com.ca.mfaas.message.log.ApimlLogger;
import com.ca.mfaas.message.yaml.YamlMessageServiceInstance;
import com.ca.mfaas.product.version.BuildInfoDetails;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildInfo.class);
    private ApimlLogger apimlLog = ApimlLogger.of(this.getClass(), YamlMessageServiceInstance.getInstance());

    public void logBuildInfo() {
        BuildInfoDetails buildInfo = this.getBuildInfoDetails();
        log.info("Service {} version {} #{} on {} by {} commit {}", new Object[]{buildInfo.getArtifact(), buildInfo.getVersion(), buildInfo.getNumber(), buildInfo.getTime(), buildInfo.getMachine(), buildInfo.getCommitId()});
    }

    public BuildInfoDetails getBuildInfoDetails() {
        Properties build = this.getProperties("META-INF/build-info.properties");
        Properties git = this.getProperties("META-INF/git.properties");
        return new BuildInfoDetails(build, git);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getProperties(String path) {
        Properties props = new Properties();
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream(path);){
            if (input == null) {
                this.apimlLog.log("apiml.common.buildInfoPropertiesNotFound", path);
                Properties properties = props;
                return properties;
            }
            props.load(input);
            return props;
        }
        catch (IOException ioe) {
            this.apimlLog.log("apiml.common.buildInfoPropertiesIOError", path, ioe.toString());
        }
        return props;
    }
}

