/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.util;

import com.ca.mfaas.util.StringUtils;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import lombok.Generated;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UrlUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UrlUtils.class);

    public static String trimSlashes(String string) {
        return string.replaceAll("^/|/$", "");
    }

    public static String getEncodedUrl(String url) {
        if (url != null) {
            return url.replaceAll("\\W", "-");
        }
        return RandomStringUtils.randomAlphanumeric((int)10);
    }

    public static String removeFirstAndLastSlash(String uri) {
        return StringUtils.removeFirstAndLastOccurrence(uri, "/");
    }

    public static String addFirstSlash(String uri) {
        return StringUtils.prependSubstring(uri, "/");
    }

    public static String removeLastSlash(String uri) {
        return StringUtils.removeLastOccurrence(uri, "/");
    }

    public static String getHostIPAddress(String fqdn) throws UnknownHostException {
        return InetAddress.getByName(fqdn).getHostAddress();
    }

    public static String getIpAddressFromUrl(String urlString) throws MalformedURLException, UnknownHostException {
        URL baseUrl = new URL(urlString);
        String hostname = baseUrl.getHost();
        return UrlUtils.getHostIPAddress(hostname);
    }

    @Generated
    private UrlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

