/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.message.core;

import com.ca.mfaas.message.core.DuplicateMessageException;
import com.ca.mfaas.message.core.Message;
import com.ca.mfaas.message.core.MessageService;
import com.ca.mfaas.message.core.MessageType;
import com.ca.mfaas.message.storage.MessageTemplateStorage;
import com.ca.mfaas.message.template.MessageTemplate;
import com.ca.mfaas.message.template.MessageTemplates;
import java.util.IllegalFormatConversionException;
import java.util.List;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageService
implements MessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageService.class);
    private final MessageTemplateStorage messageTemplateStorage = new MessageTemplateStorage();

    public AbstractMessageService(String messagesFilePath) {
        this.loadMessages(messagesFilePath);
    }

    @Override
    public Message createMessage(String key, Object ... parameters) {
        MessageTemplate messageTemplate = this.validateMessageTemplate(key);
        try {
            return Message.of(key, messageTemplate, parameters);
        }
        catch (IllegalFormatConversionException | MissingFormatArgumentException exception) {
            log.debug("Internal error: Invalid message format was used", (Throwable)exception);
            messageTemplate = this.validateMessageTemplate("apiml.common.invalidMessageTextFormat");
            return Message.of(key, messageTemplate, parameters);
        }
    }

    @Override
    public List<Message> createMessage(String key, List<Object[]> parameters) {
        return parameters.stream().filter(Objects::nonNull).map(ob -> this.createMessage(key, ob)).collect(Collectors.toList());
    }

    protected final void addMessageTemplates(MessageTemplates messageTemplates) {
        this.validateMessageTemplates(messageTemplates);
        this.messageTemplateStorage.addMessageTemplates(messageTemplates);
    }

    private void validateMessageTemplates(MessageTemplates messageTemplates) {
        String existedMessageTemplates = messageTemplates.getMessages().stream().collect(Collectors.groupingBy(MessageTemplate::getNumber, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(","));
        if (!existedMessageTemplates.equals("")) {
            String exceptionMessage = String.format("Message template with number [%s] already exists", existedMessageTemplates);
            throw new DuplicateMessageException(exceptionMessage);
        }
    }

    private MessageTemplate validateMessageTemplate(String key) {
        return this.messageTemplateStorage.getMessageTemplate(key).orElseGet(() -> {
            log.debug("Invalid message key '{}' was used. Please resolve this problem.", (Object)key);
            return this.messageTemplateStorage.getMessageTemplate("apiml.common.invalidMessageKey").orElseGet(this::getInvalidMessageTemplate);
        });
    }

    private MessageTemplate getInvalidMessageTemplate() {
        String text = "Internal error: Invalid message key '%s' provided. No default message found. Please contact support of further assistance.";
        return new MessageTemplate("apiml.common.invalidMessageKey", "ZWEAM102", MessageType.ERROR, text);
    }
}

