/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.routing;

import com.ca.mfaas.product.routing.RoutedService;
import com.ca.mfaas.product.routing.ServiceType;
import com.ca.mfaas.product.utils.UrlUtils;
import java.util.HashMap;
import java.util.Map;

public class RoutedServices {
    private final Map<String, RoutedService> routedService = new HashMap<String, RoutedService>();

    public void addRoutedService(RoutedService route) {
        this.routedService.put(route.getGatewayUrl(), route);
    }

    public RoutedService findServiceByGatewayUrl(String gatewayUrl) {
        return this.routedService.get(gatewayUrl);
    }

    public RoutedService getBestMatchingServiceUrl(String serviceUrl, ServiceType type) {
        RoutedService result = null;
        int maxSize = 0;
        for (Map.Entry<String, RoutedService> serviceEntry : this.routedService.entrySet()) {
            if (!type.equals((Object)ServiceType.ALL) && !serviceEntry.getKey().toLowerCase().startsWith(type.name().toLowerCase())) continue;
            RoutedService value = serviceEntry.getValue();
            int size = value.getServiceUrl().length();
            String routeServiceUrl = UrlUtils.removeLastSlash(value.getServiceUrl().toLowerCase());
            if (size <= maxSize || !serviceUrl.toLowerCase().startsWith(routeServiceUrl)) continue;
            result = value;
            maxSize = size;
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (Map.Entry<String, RoutedService> route : this.routedService.entrySet()) {
            builder.append(route.getKey());
            builder.append(" -> ");
            builder.append(route.toString());
            builder.append(", ");
        }
        if (this.routedService.size() > 0) {
            builder.setLength(builder.length() - 2);
        }
        builder.append("]");
        return builder.toString();
    }
}

