/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.message.yaml;

import com.ca.mfaas.message.core.AbstractMessageService;
import com.ca.mfaas.message.core.MessageLoadException;
import com.ca.mfaas.message.template.MessageTemplates;
import java.io.IOException;
import java.io.InputStream;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlMessageService
extends AbstractMessageService {
    private static final String COMMON_MESSAGES = "/mfs-common-messages.yml";

    public YamlMessageService() {
        super(COMMON_MESSAGES);
    }

    public YamlMessageService(String messagesFilePath) {
        this();
        this.loadMessages(messagesFilePath);
    }

    @Override
    public void loadMessages(String messagesFilePath) {
        try (InputStream in = YamlMessageService.class.getResourceAsStream(messagesFilePath);){
            Yaml yaml = new Yaml();
            MessageTemplates messageTemplates = (MessageTemplates)yaml.loadAs(in, MessageTemplates.class);
            super.addMessageTemplates(messageTemplates);
        }
        catch (IOException | YAMLException e) {
            throw new MessageLoadException("There is problem with reading application messages file: " + messagesFilePath, e);
        }
    }
}

