/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.message.core;

import com.ca.mfaas.message.api.ApiMessage;
import com.ca.mfaas.message.api.ApiMessageView;
import com.ca.mfaas.message.template.MessageTemplate;
import com.ca.mfaas.util.ObjectUtil;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.lang.StringEscapeUtils;

public final class Message {
    public static final String INVALID_KEY_MESSAGE = "apiml.common.invalidMessageKey";
    public static final String INVALID_MESSAGE_TEXT_FORMAT = "apiml.common.invalidMessageTextFormat";
    private final String requestedKey;
    private final MessageTemplate messageTemplate;
    private final Object[] messageParameters;

    private Message(String requestedKey, MessageTemplate messageTemplate, Object[] messageParameters) {
        this.requestedKey = requestedKey;
        this.messageTemplate = messageTemplate;
        this.messageParameters = messageParameters;
    }

    public static Message of(String requestedKey, MessageTemplate messageTemplate, Object[] messageParameters) {
        ObjectUtil.requireNotNull(requestedKey, "requestedKey can't be null");
        ObjectUtil.requireNotNull(messageTemplate, "messageTemplate can't be null");
        ObjectUtil.requireNotNull(messageParameters, "messageParameters can't be null");
        messageParameters = Message.validateParameters(messageTemplate.getKey(), requestedKey, messageParameters);
        Message.validateMessageTextFormat(messageTemplate.getText(), messageParameters);
        return new Message(requestedKey, messageTemplate, messageParameters);
    }

    private static String validateMessageTextFormat(String messageText, Object[] messageParameters) {
        return String.format(messageText, messageParameters);
    }

    private static Object[] validateParameters(String messageKey, String requestedKey, Object ... parameters) {
        if (messageKey.equals(INVALID_KEY_MESSAGE)) {
            return new Object[]{requestedKey};
        }
        return parameters;
    }

    public String getConvertedText() {
        String convertedText = Message.validateMessageTextFormat(this.messageTemplate.getText(), this.messageParameters);
        convertedText = StringEscapeUtils.escapeHtml((String)convertedText);
        return convertedText;
    }

    public String mapToReadableText() {
        return String.format("%s%s %s {%s}", this.messageTemplate.getNumber(), Character.valueOf(this.messageTemplate.getType().toChar()), this.getConvertedText(), this.generateMessageInstanceId());
    }

    public ApiMessageView mapToView() {
        return new ApiMessageView(Collections.singletonList(this.mapToApiMessage()));
    }

    public ApiMessage mapToApiMessage() {
        return new ApiMessage(this.requestedKey, this.messageTemplate.getType(), this.messageTemplate.getNumber() + this.messageTemplate.getType().toChar(), this.getConvertedText());
    }

    public String mapToLogMessage() {
        return this.mapToReadableText();
    }

    private String generateMessageInstanceId() {
        return UUID.randomUUID().toString();
    }

    public MessageTemplate getMessageTemplate() {
        return this.messageTemplate;
    }
}

