/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang.RandomStringUtils;

public class ApiInfo {
    private static final String METADATA_FORMAT = "%s.%s.%s";
    @JsonProperty(required=true)
    private String apiId;
    private String gatewayUrl;
    private String version;
    private String swaggerUrl;
    private String documentationUrl;

    public Map<String, String> generateMetadata(String serviceId) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        String encodedGatewayUrl = this.getEncodedGatewayUrl(this.gatewayUrl);
        if (this.gatewayUrl != null) {
            metadata.put(this.createMetadataKey(encodedGatewayUrl, "gatewayUrl"), this.gatewayUrl);
        }
        if (this.version != null) {
            metadata.put(this.createMetadataKey(encodedGatewayUrl, "version"), this.version);
        }
        if (this.swaggerUrl != null) {
            this.validateUrl(this.swaggerUrl, () -> String.format("The Swagger URL \"%s\" for service %s is not valid", this.swaggerUrl, serviceId));
            metadata.put(this.createMetadataKey(encodedGatewayUrl, "swaggerUrl"), this.swaggerUrl);
        }
        if (this.documentationUrl != null) {
            this.validateUrl(this.documentationUrl, () -> String.format("The documentation URL \"%s\" for service %s is not valid", this.documentationUrl, serviceId));
            metadata.put(this.createMetadataKey(encodedGatewayUrl, "documentationUrl"), this.documentationUrl);
        }
        return metadata;
    }

    private String createMetadataKey(String encodedGatewayUrl, String url) {
        return String.format(METADATA_FORMAT, "apiml.apiInfo", encodedGatewayUrl, url);
    }

    private String getEncodedGatewayUrl(String gatewayUrl) {
        if (gatewayUrl != null) {
            return gatewayUrl.replaceAll("\\W", "-");
        }
        return RandomStringUtils.randomAlphanumeric((int)10);
    }

    private void validateUrl(String url, Supplier<String> exceptionSupplier) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new InvalidParameterException(exceptionSupplier.get() + ": " + e.getMessage());
        }
    }

    @Generated
    public ApiInfo() {
    }

    @Generated
    public ApiInfo(String apiId, String gatewayUrl, String version, String swaggerUrl, String documentationUrl) {
        this.apiId = apiId;
        this.gatewayUrl = gatewayUrl;
        this.version = version;
        this.swaggerUrl = swaggerUrl;
        this.documentationUrl = documentationUrl;
    }

    @Generated
    public String getApiId() {
        return this.apiId;
    }

    @Generated
    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getSwaggerUrl() {
        return this.swaggerUrl;
    }

    @Generated
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Generated
    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    @Generated
    public void setGatewayUrl(String gatewayUrl) {
        this.gatewayUrl = gatewayUrl;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setSwaggerUrl(String swaggerUrl) {
        this.swaggerUrl = swaggerUrl;
    }

    @Generated
    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiInfo)) {
            return false;
        }
        ApiInfo other = (ApiInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiId = this.getApiId();
        String other$apiId = other.getApiId();
        if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) {
            return false;
        }
        String this$gatewayUrl = this.getGatewayUrl();
        String other$gatewayUrl = other.getGatewayUrl();
        if (this$gatewayUrl == null ? other$gatewayUrl != null : !this$gatewayUrl.equals(other$gatewayUrl)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$swaggerUrl = this.getSwaggerUrl();
        String other$swaggerUrl = other.getSwaggerUrl();
        if (this$swaggerUrl == null ? other$swaggerUrl != null : !this$swaggerUrl.equals(other$swaggerUrl)) {
            return false;
        }
        String this$documentationUrl = this.getDocumentationUrl();
        String other$documentationUrl = other.getDocumentationUrl();
        return !(this$documentationUrl == null ? other$documentationUrl != null : !this$documentationUrl.equals(other$documentationUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiId = this.getApiId();
        result = result * 59 + ($apiId == null ? 43 : $apiId.hashCode());
        String $gatewayUrl = this.getGatewayUrl();
        result = result * 59 + ($gatewayUrl == null ? 43 : $gatewayUrl.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $swaggerUrl = this.getSwaggerUrl();
        result = result * 59 + ($swaggerUrl == null ? 43 : $swaggerUrl.hashCode());
        String $documentationUrl = this.getDocumentationUrl();
        result = result * 59 + ($documentationUrl == null ? 43 : $documentationUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiInfo(apiId=" + this.getApiId() + ", gatewayUrl=" + this.getGatewayUrl() + ", version=" + this.getVersion() + ", swaggerUrl=" + this.getSwaggerUrl() + ", documentationUrl=" + this.getDocumentationUrl() + ")";
    }
}

